/*
 * Decompiled with CFR 0.152.
 */
package nomadictents;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class NTSavedData
extends SavedData {
    private static final String S_TENT_ID = "tentid";
    private static final String S_TENTS = "tents";
    private static final String S_ID = "id";
    private static final String S_UUID = "uuid";
    private final Map<Integer, UUID> tentIdMap = new HashMap<Integer, UUID>();
    private int tentId;

    public static NTSavedData get(MinecraftServer server) {
        return (NTSavedData)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(NTSavedData::read, NTSavedData::new, "nomadictents");
    }

    public static NTSavedData read(CompoundTag nbt) {
        NTSavedData instance = new NTSavedData();
        instance.load(nbt);
        return instance;
    }

    public void load(CompoundTag nbt) {
        this.tentIdMap.clear();
        ListTag tentIdTagList = nbt.m_128437_(S_TENTS, 10);
        int l = tentIdTagList.size();
        for (int i = 0; i < l; ++i) {
            CompoundTag entryTag = tentIdTagList.m_128728_(i);
            int id = entryTag.m_128451_(S_ID);
            UUID uuid = entryTag.m_128342_(S_UUID);
            this.tentIdMap.put(id, uuid);
        }
        this.tentId = nbt.m_128451_(S_TENT_ID);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag tagList = new ListTag();
        for (Map.Entry<Integer, UUID> entry : this.tentIdMap.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_(S_ID, entry.getKey().intValue());
            entryTag.m_128362_(S_UUID, entry.getValue());
            tagList.add((Object)entryTag);
        }
        nbt.m_128365_(S_TENTS, (Tag)tagList);
        nbt.m_128405_(S_TENT_ID, this.tentId);
        return nbt;
    }

    public UUID getOrCreateUuid(MinecraftServer server, int tentId) {
        if (!this.tentIdMap.containsKey(tentId)) {
            UUID uuid;
            ResourceKey worldKey;
            do {
                uuid = UUID.randomUUID();
                ResourceLocation dimension = new ResourceLocation("nomadictents", uuid.toString());
                worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension);
            } while (server.m_129784_().contains(worldKey));
            this.tentIdMap.put(tentId, uuid);
            this.m_77762_();
        }
        return this.tentIdMap.get(tentId);
    }

    public ResourceKey<Level> getOrCreateKey(MinecraftServer server, int tentId) {
        UUID uuid = this.getOrCreateUuid(server, tentId);
        ResourceLocation dimension = new ResourceLocation("nomadictents", uuid.toString());
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension);
    }

    public int getNextTentId() {
        this.m_77762_();
        return ++this.tentId;
    }

    public int getCurrentTentId() {
        return this.tentId;
    }
}

