/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.dimension;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import nomadictents.NomadicTents;
import nomadictents.dimension.DirectTeleporter;
import nomadictents.structure.TentPlacer;
import nomadictents.util.Tent;

public class DynamicDimensionHelper {
    public static void enterTent(Entity entity, ServerLevel targetWorld, Tent tent) {
        BlockPos targetPos = Tent.calculatePos(tent.getId());
        Vec3 targetVec = Vec3.m_82539_((Vec3i)targetPos.m_5484_(TentPlacer.TENT_DIRECTION, 1)).m_82520_(0.0, 0.125, 0.0);
        float targetRot = TentPlacer.TENT_DIRECTION.m_122435_();
        targetWorld.m_46865_(targetPos);
        TentPlacer.getInstance().placeOrUpgradeTent((Level)targetWorld, targetPos, tent, (ServerLevel)entity.f_19853_, entity.m_20182_(), entity.m_146908_());
        DynamicDimensionHelper.sendToDimension(entity, targetWorld, targetVec, targetRot);
    }

    public static void exitTent(Entity entity, ServerLevel targetWorld, Vec3 targetVec, float targetRot) {
        targetRot = Mth.m_14177_((float)(targetRot + 180.0f));
        targetWorld.m_46865_(new BlockPos(targetVec));
        DynamicDimensionHelper.sendToDimension(entity, targetWorld, targetVec, targetRot);
    }

    private static void sendToDimension(Entity entity, ServerLevel targetWorld, Vec3 targetVec, float targetRot) {
        targetWorld.m_46865_(new BlockPos(targetVec));
        DirectTeleporter teleporter = DirectTeleporter.create(entity, targetVec, targetRot, TentPlacer.TENT_DIRECTION);
        entity.changeDimension(targetWorld, (ITeleporter)teleporter);
        entity.f_19839_ = (Integer)NomadicTents.CONFIG.PORTAL_COOLDOWN.get();
    }

    public static boolean isInsideTent(Level level) {
        return DynamicDimensionHelper.isInsideTent(level.m_46472_().m_135782_());
    }

    public static boolean isInsideTent(ResourceLocation dimensionId) {
        return "nomadictents".equals(dimensionId.m_135827_());
    }

    public static List<ResourceKey<Level>> getTents(MinecraftServer server) {
        ArrayList<ResourceKey<Level>> list = new ArrayList<ResourceKey<Level>>();
        for (ResourceKey world : server.m_129784_()) {
            if (!DynamicDimensionHelper.isInsideTent(world.m_135782_())) continue;
            list.add((ResourceKey<Level>)world);
        }
        return list;
    }

    public static ServerLevel getOrCreateWorld(MinecraftServer server, ResourceKey<Level> levelKey, BiFunction<MinecraftServer, ResourceKey<LevelStem>, LevelStem> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(levelKey);
        if (null == existingLevel) {
            return DynamicDimensionHelper.createAndRegisterWorldAndDimension(server, map, levelKey, dimensionFactory);
        }
        return existingLevel;
    }

    private static ServerLevel createAndRegisterWorldAndDimension(MinecraftServer server, Map<ResourceKey<Level>, ServerLevel> map, ResourceKey<Level> worldKey, BiFunction<MinecraftServer, ResourceKey<LevelStem>, LevelStem> dimensionFactory) {
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)worldKey.m_135782_());
        LevelStem dimension = dimensionFactory.apply(server, (ResourceKey<LevelStem>)dimensionKey);
        ChunkProgressListener chunkListener = server.f_129756_.m_9620_(11);
        Executor executor = server.f_129738_;
        LevelStorageSource.LevelStorageAccess levelSave = server.f_129744_;
        WorldData worldData = server.m_129910_();
        WorldGenSettings worldGenSettings = worldData.m_5961_();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.m_5996_());
        Registry dimensionRegistry = worldGenSettings.m_204655_();
        if (!(dimensionRegistry instanceof WritableRegistry)) {
            throw new IllegalStateException(String.format("Unable to register dimension %s -- dimension registry not writable", dimensionKey.m_135782_()));
        }
        WritableRegistry writableRegistry = (WritableRegistry)dimensionRegistry;
        writableRegistry.m_203505_(dimensionKey, (Object)dimension, Lifecycle.stable());
        ServerLevel newWorld = new ServerLevel(server, executor, levelSave, (ServerLevelData)derivedLevelData, worldKey, dimension, chunkListener, worldGenSettings.m_64668_(), BiomeManager.m_47877_((long)worldGenSettings.m_64619_()), (List)ImmutableList.of(), false);
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newWorld.m_6857_()));
        map.put(worldKey, newWorld);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newWorld));
        return newWorld;
    }
}

