/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import nomadictents.NTRegistry;
import nomadictents.NomadicTents;
import nomadictents.block.FrameBlock;
import nomadictents.block.TentBlock;
import nomadictents.structure.TentPlacer;

public class MalletItem
extends Item {
    private final boolean isInstant;
    private static final Predicate<Block> TENT_BLOCK = b -> b instanceof TentBlock;

    public MalletItem(Tier material, boolean isInstant, Item.Properties properties) {
        super(properties.m_41503_(material.m_6609_()));
        this.isInstant = isInstant;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60734_() instanceof FrameBlock && state.m_60734_() != NTRegistry.DOOR_FRAME.get()) {
            if (context.m_43723_() != null) {
                context.m_43723_().m_6674_(context.m_43724_());
            }
            if (this.isInstant) {
                BlockPos doorPos = FrameBlock.locateDoor(context.m_43725_(), context.m_8083_(), TENT_BLOCK);
                this.useInstant(context, state, context.m_8083_(), doorPos);
                return InteractionResult.SUCCESS;
            }
            int progress = (Integer)state.m_61143_((Property)FrameBlock.PROGRESS);
            int next = progress + this.getEffectiveness(context.m_43722_(), context.m_43725_(), state, context.m_8083_(), context.m_43723_());
            if ((next = Math.min(next, 7)) >= 7) {
                if (null != context.m_43723_()) {
                    context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), p -> p.m_21190_(p.m_7655_()));
                }
                BlockState target = TentPlacer.getFrameTarget(state, context.m_43725_(), context.m_8083_());
                BlockPos doorPos = FrameBlock.locateDoor(context.m_43725_(), context.m_8083_(), TENT_BLOCK);
                if (target.m_60734_() instanceof TentBlock) {
                    target = ((TentBlock)target.m_60734_()).getDoorAwareState(context.m_43725_(), target, context.m_8083_(), doorPos);
                }
                context.m_43725_().m_7731_(context.m_8083_(), target, 3);
            } else {
                context.m_43725_().m_7731_(context.m_8083_(), (BlockState)state.m_61124_((Property)FrameBlock.PROGRESS, (Comparable)Integer.valueOf(next)), 3);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44984_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private int getEffectiveness(ItemStack stack, Level level, BlockState state, BlockPos pos, @Nullable Player player) {
        int efficiency = stack.getEnchantmentLevel(Enchantments.f_44984_);
        return (Integer)NomadicTents.CONFIG.MALLET_EFFECTIVENESS.get() + efficiency * 2;
    }

    private void useInstant(UseOnContext context, BlockState state, BlockPos pos, @Nullable BlockPos doorPos) {
        Level level = context.m_43725_();
        BlockState target = TentPlacer.getFrameTarget(state, level, pos);
        if (target.m_60734_() instanceof TentBlock) {
            target = ((TentBlock)target.m_60734_()).getDoorAwareState(level, target, pos, doorPos);
        }
        level.m_7731_(pos, target, 3);
        if (null != context.m_43723_()) {
            context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), p -> p.m_21190_(context.m_43724_()));
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos curPos = pos.m_7918_(i, j, k);
                    BlockState current = level.m_8055_(curPos);
                    if (!(current.m_60734_() instanceof FrameBlock)) continue;
                    this.useInstant(context, current, curPos, doorPos);
                }
            }
        }
    }
}

