/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;

public final class Tent
implements INBTSerializable<CompoundTag> {
    public static final String ID = "id";
    public static final String TYPE = "type";
    public static final String SIZE = "size";
    public static final String LAYERS = "layers";
    public static final String COLOR = "color";
    private TentType type = TentType.YURT;
    private TentSize size = TentSize.TINY;
    private byte layers;
    private DyeColor color;
    private int id;

    public Tent(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public Tent(int id, TentType type, TentSize size) {
        this(id, type, size, 0);
    }

    public Tent(int id, TentType type, TentSize size, byte layers) {
        this(id, type, size, layers, null);
    }

    public Tent(int id, TentType type, TentSize size, byte layers, DyeColor color) {
        this.id = id;
        this.type = type;
        this.size = size;
        this.layers = layers;
        this.color = color;
    }

    public static Tent from(ItemStack stack, TentType type, TentSize size) {
        CompoundTag tag = stack.m_41784_();
        int id = tag.m_128451_(ID);
        byte layers = tag.m_128445_(LAYERS);
        DyeColor color = null;
        if (tag.m_128441_(COLOR)) {
            color = DyeColor.m_41057_((String)tag.m_128461_(COLOR), (DyeColor)DyeColor.WHITE);
        }
        return new Tent(id, type, size, layers, color);
    }

    public static Tent from(ItemStack stack) {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
        int index = itemName.indexOf("_");
        if (index >= 0) {
            String typeName = itemName.substring(0, index);
            String sizeName = itemName.substring(index + 1);
            TentType type = TentType.getByName(typeName).result().orElse(TentType.YURT);
            TentSize size = TentSize.getByName(sizeName).result().orElse(TentSize.TINY);
            return Tent.from(stack, type, size);
        }
        return Tent.from(stack, TentType.YURT, TentSize.TINY);
    }

    public static BlockPos calculatePos(int id) {
        return new BlockPos(0, 64, 0);
    }

    public ItemStack asItem() {
        String itemName = this.size.m_7912_() + "_" + this.type.m_7912_();
        ResourceLocation itemId = new ResourceLocation("nomadictents", itemName);
        Item tentItem = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (tentItem != null) {
            ItemStack tentStack = new ItemStack((ItemLike)tentItem);
            tentStack.m_41784_().m_128405_(ID, this.id);
            tentStack.m_41783_().m_128344_(LAYERS, this.layers);
            if (this.color != null) {
                tentStack.m_41783_().m_128359_(COLOR, this.color.m_7912_());
            }
            return tentStack;
        }
        return ItemStack.f_41583_;
    }

    public int getId() {
        return this.id;
    }

    public TentType getType() {
        return this.type;
    }

    public TentSize getSize() {
        return this.size;
    }

    public byte getLayers() {
        return this.layers;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(ID, this.id);
        nbt.m_128359_(TYPE, this.type.m_7912_());
        nbt.m_128359_(SIZE, this.size.m_7912_());
        nbt.m_128344_(LAYERS, this.layers);
        if (this.color != null) {
            nbt.m_128359_(COLOR, this.color.m_7912_());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.id = nbt.m_128451_(ID);
        this.type = TentType.getByName(nbt.m_128461_(TYPE)).result().orElse(TentType.YURT);
        this.size = TentSize.getByName(nbt.m_128461_(SIZE)).result().orElse(TentSize.TINY);
        this.layers = nbt.m_128445_(LAYERS);
        if (nbt.m_128441_(COLOR)) {
            this.color = DyeColor.m_41057_((String)nbt.m_128461_(COLOR), (DyeColor)DyeColor.WHITE);
        }
    }

    public String toString() {
        return "Tent{type=" + this.type + ", size=" + this.size + ", layers=" + this.layers + ", id=" + this.id + "}";
    }
}

