/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.block;

import com.nyfaria.numismaticoverhaul.NumismaticOverhaul;
import com.nyfaria.numismaticoverhaul.block.ShopBlockEntity;
import com.nyfaria.numismaticoverhaul.block.ShopOffer;
import com.nyfaria.numismaticoverhaul.cap.CurrencyHolderAttacher;
import com.nyfaria.numismaticoverhaul.client.gui.ShopScreen;
import com.nyfaria.numismaticoverhaul.init.MenuInit;
import com.nyfaria.numismaticoverhaul.network.NetworkHandler;
import com.nyfaria.numismaticoverhaul.network.ShopScreenHandlerRequestC2SPacket;
import com.nyfaria.numismaticoverhaul.network.UpdateShopScreenS2CPacket;
import com.nyfaria.numismaticoverhaul.owostuff.client.screens.ScreenUtils;
import com.nyfaria.numismaticoverhaul.owostuff.client.screens.SlotGenerator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class ShopScreenHandler
extends AbstractContainerMenu {
    private final Player owner;
    private final Container shopInventory;
    private final SimpleContainer bufferInventory = new SimpleContainer(1);
    private final List<ShopOffer> offers;
    private ShopBlockEntity shop = null;

    public ShopScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(27));
    }

    public ShopScreenHandler(int syncId, Inventory playerInventory, Container shopInventory) {
        super((MenuType)MenuInit.SHOP.get(), syncId);
        this.shopInventory = shopInventory;
        this.owner = playerInventory.f_35978_;
        if (!this.owner.f_19853_.f_46443_) {
            this.shop = (ShopBlockEntity)shopInventory;
            this.offers = this.shop.getOffers();
            this.updateClient();
        } else {
            this.offers = new ArrayList<ShopOffer>();
        }
        SlotGenerator.begin(x$0 -> this.m_38897_((Slot)x$0), 8, 17).slotFactory((inv, index, x, y) -> new AutoHidingSlot(inv, index, x, y, 0, false)).grid(this.shopInventory, 0, 9, 3).slotFactory(Slot::new).moveTo(8, 85).playerInventory(playerInventory);
        this.bufferInventory.m_19164_(this::onBufferChanged);
        this.m_38897_(new AutoHidingSlot((Container)this.bufferInventory, 0, 186, 14, 0, true){

            public boolean m_5857_(ItemStack stack) {
                ItemStack shadow = stack.m_41777_();
                this.m_5852_(shadow);
                return false;
            }

            public boolean m_8010_(Player playerEntity) {
                this.m_5852_(ItemStack.f_41583_);
                return false;
            }
        });
    }

    private void onBufferChanged(Container inventory) {
        Screen screen;
        if (this.owner.f_19853_.f_46443_ && (screen = Minecraft.m_91087_().f_91080_) instanceof ShopScreen) {
            ShopScreen screen2 = (ShopScreen)screen;
            screen2.afterDataUpdate();
        }
    }

    public boolean m_6875_(Player player) {
        return this.shopInventory.m_6542_(player);
    }

    public void loadOffer(long index) {
        if (!this.owner.f_19853_.f_46443_) {
            if (index > (long)(this.offers.size() - 1)) {
                NumismaticOverhaul.LOGGER.error("Player {} attempted to load invalid trade at index {}", (Object)this.owner.m_7755_(), (Object)index);
                return;
            }
            this.bufferInventory.m_6836_(0, this.offers.get((int)index).getSellStack());
        } else {
            NetworkHandler.INSTANCE.sendToServer((Object)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.LOAD_OFFER, index));
        }
    }

    public void createOffer(long price) {
        if (!this.owner.f_19853_.f_46443_) {
            ItemStack stack = this.bufferInventory.m_8020_(0);
            if (stack.m_41619_()) {
                return;
            }
            this.shop.addOrReplaceOffer(new ShopOffer(stack, price));
            this.updateClient();
        } else {
            NetworkHandler.INSTANCE.sendToServer((Object)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.CREATE_OFFER, price));
        }
    }

    public void extractCurrency() {
        if (!this.owner.f_19853_.f_46443_) {
            CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)this.owner).modify(this.shop.getStoredCurrency());
            this.shop.setStoredCurrency(0L);
            this.updateClient();
        } else {
            NetworkHandler.INSTANCE.sendToServer((Object)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.EXTRACT_CURRENCY));
        }
    }

    public void deleteOffer() {
        if (!this.owner.f_19853_.f_46443_) {
            this.shop.deleteOffer(this.bufferInventory.m_8020_(0));
            this.updateClient();
        } else {
            NetworkHandler.INSTANCE.sendToServer((Object)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.DELETE_OFFER));
        }
    }

    public void toggleTransfer() {
        if (!this.owner.f_19853_.f_46443_) {
            this.shop.toggleTransfer();
            this.updateClient();
        } else {
            NetworkHandler.INSTANCE.sendToServer((Object)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.TOGGLE_TRANSFER));
        }
    }

    private void updateClient() {
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.owner), (Object)new UpdateShopScreenS2CPacket(this.shop));
    }

    public ItemStack getBufferStack() {
        return this.bufferInventory.m_8020_(0);
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        return ScreenUtils.handleSlotTransfer(this, invSlot, this.shopInventory.m_6643_());
    }

    private static class AutoHidingSlot
    extends Slot {
        private final int targetTab;
        private final boolean hide;

        public AutoHidingSlot(Container inventory, int index, int x, int y, int targetTab, boolean hide) {
            super(inventory, index, x, y);
            this.targetTab = targetTab;
            this.hide = hide;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean m_6659_() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (!(screen instanceof ShopScreen)) {
                return true;
            }
            ShopScreen screen2 = (ShopScreen)screen;
            return this.hide ? screen2.tab() != this.targetTab : screen2.tab() == this.targetTab;
        }
    }
}

