/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.client.gui;

import com.nyfaria.numismaticoverhaul.block.ShopOffer;
import com.nyfaria.numismaticoverhaul.block.ShopScreenHandler;
import com.nyfaria.numismaticoverhaul.currency.CurrencyResolver;
import com.nyfaria.numismaticoverhaul.network.UpdateShopScreenS2CPacket;
import com.nyfaria.numismaticoverhaul.owostuff.ops.TextOps;
import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseUIModelHandledScreen;
import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseUIModelScreen;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.ButtonComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.ItemComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.LabelComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.TextureComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.FlowLayout;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.ScrollContainer;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.inject.ButtonWidgetExtension;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.UISounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ShopScreen
extends BaseUIModelHandledScreen<FlowLayout, ShopScreenHandler> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("numismaticoverhaul", "textures/gui/shop_gui.png");
    public static final ResourceLocation TRADES_TEXTURE = new ResourceLocation("numismaticoverhaul", "textures/gui/shop_gui_trades.png");
    private final List<Button> tabButtons = new ArrayList<Button>();
    private final List<ShopOffer> offers = new ArrayList<ShopOffer>();
    private Runnable afterDataUpdate = () -> {};
    private Consumer<String> priceDisplay = s -> {};
    private int tab = 0;

    public ShopScreen(ShopScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title, FlowLayout.class, BaseUIModelScreen.DataSource.asset(new ResourceLocation("numismaticoverhaul", "shop")));
        ++this.f_97731_;
        this.f_97729_ = 5;
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        this.tabButtons.clear();
        FlowLayout leftColumn = rootComponent.childById(FlowLayout.class, "left-column");
        leftColumn.child(this.makeTabButton(Items.f_42009_, false, button -> this.selectTab(0)));
        leftColumn.child(this.makeTabButton(Items.f_42616_, true, button -> this.selectTab(1)));
        ((ButtonWidgetExtension)rootComponent.childById(ButtonComponent.class, "extract-button")).onPress(button -> ((ShopScreenHandler)this.f_97732_).extractCurrency());
        rootComponent.childById(FlowLayout.class, "transfer-button").mouseDown().subscribe((x, y, button) -> {
            if (button != 0) {
                return false;
            }
            ((ShopScreenHandler)this.f_97732_).toggleTransfer();
            UISounds.playInteractionSound();
            return true;
        });
    }

    public void update(UpdateShopScreenS2CPacket data) {
        if (this.uiAdapter == null) {
            return;
        }
        long[] storedCurrency = CurrencyResolver.splitValues(data.storedCurrency());
        this.component(LabelComponent.class, "bronze-count").text((Component)Component.m_237113_((String)String.valueOf(storedCurrency[0])));
        this.component(LabelComponent.class, "silver-count").text((Component)Component.m_237113_((String)String.valueOf(storedCurrency[1])));
        this.component(LabelComponent.class, "gold-count").text((Component)Component.m_237113_((String)String.valueOf(storedCurrency[2])));
        int prevOffers = this.offers.size();
        this.offers.clear();
        this.offers.addAll(data.offers());
        this.populateTrades(this.tab);
        if (this.tab == 1 && this.offers.size() > prevOffers) {
            ScrollContainer offersScroll = this.component(ScrollContainer.class, "offer-container");
            FlowLayout leftColumn = offersScroll.childById(FlowLayout.class, "first-trades-column");
            offersScroll.scrollTo(leftColumn.children().get(leftColumn.children().size() - 1));
        }
        this.component(FlowLayout.class, "transfer-button").tooltip((Component)(data.transferEnabled() ? Component.m_237115_((String)"gui.numismaticoverhaul.shop.transfer_tooltip.enabled") : Component.m_237115_((String)"gui.numismaticoverhaul.shop.transfer_tooltip.disabled")));
        this.component(LabelComponent.class, "transfer-label").text((Component)(data.transferEnabled() ? TextOps.withColor("\u2714", 2686911) : TextOps.withColor("\u2718", 15408438)));
        this.afterDataUpdate();
    }

    public void afterDataUpdate() {
        this.afterDataUpdate.run();
    }

    private void selectTab(int index) {
        if (this.tab == index) {
            return;
        }
        if (index == 0) {
            this.swapBackgroundTexture(TEXTURE);
            this.f_97729_ = 5;
            this.component(FlowLayout.class, "right-column").removeChild(this.component(FlowLayout.class, "trade-edit-widget"));
            this.afterDataUpdate = () -> {};
            this.priceDisplay = s -> {};
        } else {
            this.swapBackgroundTexture(TRADES_TEXTURE);
            this.f_97729_ = 69420;
            FlowLayout editWidget = this.model.expandTemplate(FlowLayout.class, "trade-edit-widget", Map.of());
            ButtonComponent submitButton = editWidget.childByIdOther(ButtonComponent.class, "submit-button");
            ButtonComponent deleteButton = editWidget.childByIdOther(ButtonComponent.class, "delete-button");
            EditBox priceField = editWidget.childByIdOther(EditBox.class, "price-field");
            priceField.m_94199_(7);
            priceField.m_94153_(s -> s.matches("\\d*"));
            priceField.m_94151_(s -> {
                this.afterDataUpdate();
                long[] price = CurrencyResolver.splitValues(s.isBlank() ? 0L : (long)Integer.parseInt(s));
                this.component(LabelComponent.class, "offer-bronze-count").text((Component)Component.m_237113_((String)String.valueOf(price[0])));
                this.component(LabelComponent.class, "offer-silver-count").text((Component)Component.m_237113_((String)String.valueOf(price[1])));
                this.component(LabelComponent.class, "offer-gold-count").text((Component)Component.m_237113_((String)String.valueOf(price[2])));
            });
            submitButton.onPress(button -> ((ShopScreenHandler)this.f_97732_).createOffer(Integer.parseInt(priceField.m_94155_())));
            deleteButton.onPress(button -> ((ShopScreenHandler)this.f_97732_).deleteOffer());
            this.priceDisplay = arg_0 -> ((EditBox)priceField).m_94144_(arg_0);
            this.afterDataUpdate = () -> {
                String priceText = priceField.m_94155_();
                boolean hasOffer = this.hasOfferFor(((ShopScreenHandler)this.f_97732_).getBufferStack());
                submitButton.f_93623_ = !priceText.isBlank() && Integer.parseInt(priceText) > 0 && !((ShopScreenHandler)this.f_97732_).getBufferStack().m_41619_() && (this.offers.size() < 24 || hasOffer);
                deleteButton.f_93623_ = hasOffer;
            };
            this.component(FlowLayout.class, "right-column").child(0, editWidget);
        }
        this.populateTrades(index);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            this.tabButtons.get((int)i).f_93623_ = i != index;
        }
        this.tab = index;
    }

    private boolean hasOfferFor(ItemStack stack) {
        return this.offers.stream().anyMatch(offer -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)offer.getSellStack()));
    }

    private void populateTrades(int tab) {
        FlowLayout firstColumn = this.component(FlowLayout.class, "first-trades-column");
        FlowLayout secondColumn = this.component(FlowLayout.class, "second-trades-column");
        firstColumn.clearChildren();
        secondColumn.clearChildren();
        if (tab == 0) {
            return;
        }
        for (int i = 0; i < this.offers.size(); ++i) {
            int offerIndex = i;
            ShopOffer offer = this.offers.get(offerIndex);
            FlowLayout component = this.model.expandTemplate(FlowLayout.class, "trade-button", Map.of("price", String.valueOf(offer.getPrice())));
            component.childById(ItemComponent.class, "item-display").stack(offer.getSellStack());
            ((ButtonWidgetExtension)component.childByIdOther(Button.class, "trade-button")).onPress(button -> {
                ((ShopScreenHandler)this.f_97732_).loadOffer(offerIndex);
                this.priceDisplay.accept(String.valueOf(offer.getPrice()));
            });
            (i % 2 == 0 ? firstColumn : secondColumn).child(component);
        }
    }

    private void swapBackgroundTexture(ResourceLocation newTexture) {
        FlowLayout background = this.component(FlowLayout.class, "background");
        background.removeChild(background.children().get(0));
        background.child(0, this.model.expandTemplate(TextureComponent.class, "background-texture", Map.of("texture", newTexture.toString())));
    }

    private FlowLayout makeTabButton(Item icon, boolean active, Button.OnPress onPress) {
        FlowLayout buttonContainer = this.model.expandTemplate(FlowLayout.class, "tab-button", Map.of("icon-item", Registry.f_122827_.m_7981_((Object)icon).toString()));
        Button button = buttonContainer.childByIdOther(Button.class, "tab-button");
        this.tabButtons.add(button);
        button.f_93623_ = active;
        ((ButtonWidgetExtension)button).onPress(onPress);
        return buttonContainer;
    }

    private <C extends ModComponent> C component(Class<C> componentClass, String id) {
        return ((FlowLayout)this.uiAdapter.rootComponent).childById(componentClass, id);
    }

    public int tab() {
        return this.tab;
    }
}

