/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.client.gui.purse;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.cap.CurrencyHolder;
import com.nyfaria.numismaticoverhaul.client.gui.purse.AlwaysOnTopTexturedButtonWidget;
import com.nyfaria.numismaticoverhaul.currency.Currency;
import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.currency.CurrencyResolver;
import com.nyfaria.numismaticoverhaul.network.NetworkHandler;
import com.nyfaria.numismaticoverhaul.network.RequestPurseActionC2SPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableInt;

public class PurseWidget
extends GuiComponent
implements Widget,
GuiEventListener,
NarratableEntry {
    public static final ResourceLocation TEXTURE = new ResourceLocation("numismaticoverhaul", "textures/gui/purse_widget.png");
    private final Minecraft client;
    private final int x;
    private final int y;
    private boolean active = false;
    private final List<Button> buttons = new ArrayList<Button>();
    private final MutableInt goldAmount = new MutableInt(0);
    private final MutableInt silverAmount = new MutableInt(0);
    private final MutableInt bronzeAmount = new MutableInt(0);
    private final CurrencyHolder currencyStorage;

    public PurseWidget(int x, int y, Minecraft client, CurrencyHolder currencyStorage) {
        this.client = client;
        this.x = x;
        this.y = y;
        this.buttons.add((Button)new SmallPurseAdjustButton(x + 18, y + 10, button -> this.modifyInBounds(this.goldAmount, true, Currency.GOLD), true));
        this.buttons.add((Button)new SmallPurseAdjustButton(x + 18, y + 16, button -> this.modifyInBounds(this.goldAmount, false, Currency.GOLD), false));
        this.buttons.add((Button)new SmallPurseAdjustButton(x + 18, y + 22, button -> this.modifyInBounds(this.silverAmount, true, Currency.SILVER), true));
        this.buttons.add((Button)new SmallPurseAdjustButton(x + 18, y + 28, button -> this.modifyInBounds(this.silverAmount, false, Currency.SILVER), false));
        this.buttons.add((Button)new SmallPurseAdjustButton(x + 18, y + 34, button -> this.modifyInBounds(this.bronzeAmount, true, Currency.BRONZE), true));
        this.buttons.add((Button)new SmallPurseAdjustButton(x + 18, y + 40, button -> this.modifyInBounds(this.bronzeAmount, false, Currency.BRONZE), false));
        this.buttons.add((Button)new AlwaysOnTopTexturedButtonWidget(x + 3, y + 46, 24, 8, 37, 0, 16, TEXTURE, button -> {
            if (Screen.m_96638_() && Screen.m_96637_()) {
                NetworkHandler.INSTANCE.sendToServer((Object)RequestPurseActionC2SPacket.extractAll());
            } else if (this.selectedValue() > 0L) {
                NetworkHandler.INSTANCE.sendToServer((Object)RequestPurseActionC2SPacket.extract(this.selectedValue()));
                this.resetSelectedValue();
            }
        }));
        this.currencyStorage = currencyStorage;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!this.active) {
            return;
        }
        RenderSystem.m_69465_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrices, this.x, this.y, 0, 0, 37, 60);
        for (Button button : this.buttons) {
            button.m_6305_(matrices, mouseX, mouseY, delta);
        }
        this.client.f_91062_.m_92889_(matrices, (Component)Component.m_237113_((String)("" + this.goldAmount)), (float)(this.x + 5), (float)(this.y + 12), 0xFFFFFF);
        this.client.f_91062_.m_92889_(matrices, (Component)Component.m_237113_((String)("" + this.silverAmount)), (float)(this.x + 5), (float)(this.y + 24), 0xFFFFFF);
        this.client.f_91062_.m_92889_(matrices, (Component)Component.m_237113_((String)("" + this.bronzeAmount)), (float)(this.x + 5), (float)(this.y + 36), 0xFFFFFF);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.active || this.client.f_91074_.m_5833_()) {
            return false;
        }
        for (Button buttonWidget : this.buttons) {
            if (!buttonWidget.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.m_5953_(mouseX, mouseY);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + 37) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 57) && this.active;
    }

    public void toggleActive() {
        this.active = !this.active;
    }

    private void modifyInBounds(MutableInt value, boolean add, Currency currency) {
        this.modifyInBounds(value, Screen.m_96638_() ? 10 : 1, add, currency);
    }

    private void modifyInBounds(MutableInt value, int modifyBy, boolean add, Currency currency) {
        long stepSize = currency.getRawValue(1L);
        long possibleSteps = (this.currencyStorage.getValue() - this.selectedValue()) / stepSize;
        int upperBound = CurrencyConverter.asInt(Math.min((long)value.intValue() + possibleSteps, 99L));
        if (add) {
            value.add(modifyBy);
        } else {
            value.subtract(modifyBy);
        }
        if (value.intValue() < 0) {
            value.setValue(0);
        }
        if (value.intValue() > upperBound) {
            value.setValue(upperBound);
        }
    }

    private long selectedValue() {
        return CurrencyResolver.combineValues(new long[]{this.bronzeAmount.getValue().intValue(), this.silverAmount.getValue().intValue(), this.goldAmount.getValue().intValue()});
    }

    private void resetSelectedValue() {
        this.currencyStorage.silentModify(-this.selectedValue());
        int oldGoldAmount = this.goldAmount.intValue();
        int oldSilverAmount = this.silverAmount.intValue();
        int oldBronzeAmount = this.bronzeAmount.intValue();
        this.goldAmount.setValue(0);
        this.bronzeAmount.setValue(0);
        this.silverAmount.setValue(0);
        this.modifyInBounds(this.goldAmount, oldGoldAmount, true, Currency.GOLD);
        this.modifyInBounds(this.silverAmount, oldSilverAmount, true, Currency.SILVER);
        this.modifyInBounds(this.bronzeAmount, oldBronzeAmount, true, Currency.BRONZE);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.FOCUSED;
    }

    public void m_142291_(NarrationElementOutput builder) {
    }

    public static class SmallPurseAdjustButton
    extends AlwaysOnTopTexturedButtonWidget {
        public SmallPurseAdjustButton(int x, int y, Button.OnPress pressAction, boolean add) {
            super(x, y, 9, 5, add ? 37 : 46, 24, 10, TEXTURE, pressAction);
        }
    }
}

