/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.currency;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.nyfaria.numismaticoverhaul.NumismaticOverhaul;
import com.nyfaria.numismaticoverhaul.currency.CurrencyResolver;
import com.nyfaria.numismaticoverhaul.item.MoneyBagItem;
import java.util.function.Consumer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class MoneyBagLootEntry
extends LootPoolSingletonContainer {
    private final int min;
    private final int max;

    private MoneyBagLootEntry(int min, int max, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.min = min;
        this.max = max;
    }

    protected void m_6948_(Consumer<ItemStack> lootConsumer, LootContext context) {
        int value = Mth.m_216271_((RandomSource)context.m_230907_(), (int)this.min, (int)this.max);
        if (value == 0) {
            return;
        }
        lootConsumer.accept(MoneyBagItem.createCombined(CurrencyResolver.splitValues(value)));
    }

    public static LootPoolSingletonContainer.Builder<?> builder(int min, int max) {
        return MoneyBagLootEntry.m_79687_((weight, quality, conditions, functions) -> new MoneyBagLootEntry(min, max, weight, quality, conditions, functions));
    }

    public LootPoolEntryType m_6751_() {
        return NumismaticOverhaul.MONEY_BAG_ENTRY;
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<MoneyBagLootEntry> {
        public void serializeCustom(JsonObject jsonObject, MoneyBagLootEntry moneyBagLootEntry, JsonSerializationContext jsonSerializationContext) {
            super.m_7219_(jsonObject, (LootPoolSingletonContainer)moneyBagLootEntry, jsonSerializationContext);
            jsonObject.addProperty("min", (Number)moneyBagLootEntry.min);
            jsonObject.addProperty("max", (Number)moneyBagLootEntry.max);
        }

        protected MoneyBagLootEntry deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int i, int j, LootItemCondition[] lootConditions, LootItemFunction[] lootFunctions) {
            int mix = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"min", (int)0);
            int max = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"max");
            return new MoneyBagLootEntry(mix, max, i, j, lootConditions, lootFunctions);
        }
    }
}

