/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.item;

import com.nyfaria.numismaticoverhaul.NumismaticOverhaul;
import com.nyfaria.numismaticoverhaul.cap.CurrencyHolderAttacher;
import com.nyfaria.numismaticoverhaul.currency.Currency;
import com.nyfaria.numismaticoverhaul.item.CurrencyItem;
import com.nyfaria.numismaticoverhaul.item.CurrencyTooltipData;
import com.nyfaria.numismaticoverhaul.item.MoneyBagItem;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CoinItem
extends Item
implements CurrencyItem {
    public final Currency currency;
    public final Style NAME_STYLE;

    public CoinItem(Currency currency) {
        super(new Item.Properties().m_41491_(NumismaticOverhaul.NUMISMATIC_GROUP).m_41487_(99));
        this.currency = currency;
        this.NAME_STYLE = Style.f_131099_.m_131148_(TextColor.m_131266_((int)currency.getNameColor()));
    }

    public boolean m_142305_(ItemStack clickedStack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        Item item;
        if (slot instanceof MerchantResultSlot) {
            return false;
        }
        if (clickType != ClickAction.PRIMARY) {
            return false;
        }
        if (otherStack.m_41720_() == this && otherStack.m_41613_() + clickedStack.m_41613_() <= otherStack.m_41741_() || !((item = otherStack.m_41720_()) instanceof CurrencyItem)) {
            return false;
        }
        CurrencyItem currencyItem = (CurrencyItem)item;
        long[] values = currencyItem.getCombinedValue(otherStack);
        int n = this.currency.ordinal();
        values[n] = values[n] + (long)clickedStack.m_41613_();
        ItemStack stack = MoneyBagItem.createCombined(values);
        if (!slot.m_5857_(stack)) {
            return false;
        }
        slot.m_5852_(stack);
        cursorStackReference.m_142104_(ItemStack.f_41583_);
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack clickedStack = user.m_21120_(hand);
        long rawValue = ((CoinItem)clickedStack.m_41720_()).currency.getRawValue(clickedStack.m_41613_());
        if (!world.f_46443_) {
            CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)user).modify(rawValue);
        }
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new CurrencyTooltipData(this.currency.getRawValue(stack.m_41613_()), CurrencyItem.hasOriginalValue(stack) ? CurrencyItem.getOriginalValue(stack) : -1L));
    }

    public Component m_41466_() {
        return super.m_41466_().m_6881_().m_6270_(this.NAME_STYLE);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6881_().m_6270_(this.NAME_STYLE);
    }

    @Override
    public boolean wasAdjusted(ItemStack other) {
        return other.m_41720_() != this;
    }

    @Override
    public long getValue(ItemStack stack) {
        return this.currency.getRawValue(stack.m_41613_());
    }

    @Override
    public long[] getCombinedValue(ItemStack stack) {
        long[] values = new long[3];
        values[this.currency.ordinal()] = stack.m_41613_();
        return values;
    }
}

