/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.client.texture.SpriteSheetMetadata;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.resources.ResourceLocation;

public class AnimatedTextureDrawable
implements Widget {
    private final SpriteSheetMetadata metadata;
    private final ResourceLocation texture;
    private final int validFrames;
    private final int delay;
    private final boolean loop;
    private final int rows;
    private long startTime = -1L;
    private final int width;
    private final int height;
    private int x;
    private int y;

    public AnimatedTextureDrawable(int x, int y, ResourceLocation texture, SpriteSheetMetadata metadata, int delay, boolean loop) {
        this(x, y, metadata.width(), metadata.height(), texture, metadata, delay, loop);
    }

    public AnimatedTextureDrawable(int x, int y, int width, int height, ResourceLocation texture, SpriteSheetMetadata metadata, int delay, boolean loop) {
        this.x = x;
        this.y = y;
        this.texture = texture;
        this.delay = delay;
        this.metadata = metadata;
        this.width = width;
        this.height = height;
        this.loop = loop;
        int columns = metadata.width() / metadata.frameWidth();
        this.rows = metadata.height() / metadata.frameHeight();
        this.validFrames = columns * this.rows;
    }

    public void render(int x, int y, PoseStack matrixStack, int mouseX, int mouseY, float delta) {
        this.x = x;
        this.y = y;
        this.m_6305_(matrixStack, mouseX, mouseY, delta);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.startTime == -1L) {
            this.startTime = Util.m_137550_();
        }
        long currentTime = Util.m_137550_();
        long frame = Math.min((long)(this.validFrames - 1), (currentTime - this.startTime) / (long)this.delay);
        if (this.loop && frame == (long)(this.validFrames - 1)) {
            this.startTime = Util.m_137550_();
            frame = 0L;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        GuiComponent.m_93133_((PoseStack)matrices, (int)this.x, (int)this.y, (float)(frame / (long)this.rows * (long)this.metadata.frameWidth()), (float)(frame % (long)this.rows * (long)this.metadata.frameHeight()), (int)this.width, (int)this.height, (int)this.metadata.width(), (int)this.metadata.height());
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
    }
}

