/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.nbt;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class NbtKey<T> {
    protected final String key;
    protected final Type<T> type;

    public NbtKey(String key, Type<T> type) {
        this.key = key;
        this.type = type;
    }

    @Deprecated
    public T get(@NotNull CompoundTag nbt) {
        return this.type.getter.apply(nbt, this.key);
    }

    @Deprecated
    public void put(@NotNull CompoundTag nbt, T value) {
        this.type.setter.accept((Object)nbt, (Object)this.key, value);
    }

    @Deprecated
    public void delete(@NotNull CompoundTag nbt) {
        nbt.m_128473_(this.key);
    }

    @Deprecated
    public boolean isIn(@NotNull CompoundTag nbt) {
        return nbt.m_128425_(this.key, (int)this.type.nbtEquivalent);
    }

    public static final class Type<T> {
        public static final Type<Byte> BYTE = new Type<Byte>(1, CompoundTag::m_128445_, CompoundTag::m_128344_);
        public static final Type<Short> SHORT = new Type<Short>(2, CompoundTag::m_128448_, CompoundTag::m_128376_);
        public static final Type<Integer> INT = new Type<Integer>(3, CompoundTag::m_128451_, CompoundTag::m_128405_);
        public static final Type<Long> LONG = new Type<Long>(4, CompoundTag::m_128454_, CompoundTag::m_128356_);
        public static final Type<Float> FLOAT = new Type<Float>(5, CompoundTag::m_128457_, CompoundTag::m_128350_);
        public static final Type<Double> DOUBLE = new Type<Double>(6, CompoundTag::m_128459_, CompoundTag::m_128347_);
        public static final Type<byte[]> BYTE_ARRAY = new Type<byte[]>(7, CompoundTag::m_128463_, CompoundTag::m_128382_);
        public static final Type<String> STRING = new Type<String>(8, CompoundTag::m_128461_, CompoundTag::m_128359_);
        public static final Type<CompoundTag> COMPOUND = new Type<CompoundTag>(10, CompoundTag::m_128469_, CompoundTag::m_128365_);
        public static final Type<int[]> INT_ARRAY = new Type<int[]>(11, CompoundTag::m_128465_, CompoundTag::m_128385_);
        public static final Type<long[]> LONG_ARRAY = new Type<long[]>(12, CompoundTag::m_128467_, CompoundTag::m_128388_);
        public static final Type<ItemStack> ITEM_STACK = new Type<ItemStack>(10, Type::readItemStack, Type::writeItemStack);
        public static final Type<ResourceLocation> IDENTIFIER = new Type<ResourceLocation>(8, Type::readIdentifier, Type::writeIdentifier);
        public static final Type<Boolean> BOOLEAN = new Type<Boolean>(1, CompoundTag::m_128471_, CompoundTag::m_128379_);
        private final byte nbtEquivalent;
        private final BiFunction<CompoundTag, String, T> getter;
        private final TriConsumer<CompoundTag, String, T> setter;

        private Type(byte nbtEquivalent, BiFunction<CompoundTag, String, T> getter, TriConsumer<CompoundTag, String, T> setter) {
            this.nbtEquivalent = nbtEquivalent;
            this.getter = getter;
            this.setter = setter;
        }

        public <R> Type<R> then(Function<T, R> getter, Function<R, T> setter) {
            return new Type<Object>(this.nbtEquivalent, (compound, s) -> getter.apply(this.getter.apply((CompoundTag)compound, (String)s)), (compound, s, r) -> this.setter.accept(compound, s, setter.apply(r)));
        }

        public static <T> Type<T> of(byte nbtType, BiFunction<CompoundTag, String, T> getter, TriConsumer<CompoundTag, String, T> setter) {
            return new Type<T>(nbtType, getter, setter);
        }

        public static <T> Type<T> ofRegistry(Registry<T> registry) {
            return new Type<Object>(8, (compound, s) -> registry.m_7745_(new ResourceLocation(compound.m_128461_(s))), (compound, s, t) -> compound.m_128359_(s, registry.m_7981_(t).toString()));
        }

        private static void writeItemStack(CompoundTag nbt, String key, ItemStack stack) {
            nbt.m_128365_(key, (Tag)stack.m_41739_(new CompoundTag()));
        }

        private static ItemStack readItemStack(CompoundTag nbt, String key) {
            return nbt.m_128425_(key, 10) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_(key)) : ItemStack.f_41583_;
        }

        private static void writeIdentifier(CompoundTag nbt, String key, ResourceLocation identifier) {
            nbt.m_128359_(key, identifier.toString());
        }

        private static ResourceLocation readIdentifier(CompoundTag nbt, String key) {
            return nbt.m_128425_(key, 8) ? new ResourceLocation(nbt.m_128461_(key)) : null;
        }
    }

    public static final class ListKey<T>
    extends NbtKey<ListTag> {
        private final Type<T> elementType;

        public ListKey(String key, Type<T> elementType) {
            super(key, null);
            this.elementType = elementType;
        }

        @Override
        public ListTag get(@NotNull CompoundTag nbt) {
            return nbt.m_128437_(this.key, (int)this.elementType.nbtEquivalent);
        }

        @Override
        public void put(@NotNull CompoundTag nbt, ListTag value) {
            nbt.m_128365_(this.key, (Tag)value);
        }

        @Override
        public boolean isIn(@NotNull CompoundTag nbt) {
            return nbt.m_128425_(this.key, 9);
        }
    }
}

