/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ops;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class TextOps {
    public static MutableComponent concat(Component prefix, Component text) {
        return Component.m_237119_().m_7220_(prefix).m_7220_(text);
    }

    public static MutableComponent withColor(String text, int color) {
        return Component.m_237113_((String)text).m_6270_(Style.f_131099_.m_178520_(color));
    }

    public static MutableComponent translateWithColor(String text, int color) {
        return Component.m_237115_((String)text).m_6270_(Style.f_131099_.m_178520_(color));
    }

    public static MutableComponent withFormatting(String text, ChatFormatting ... formatting) {
        String[] textPieces = text.split("\u00a7");
        if (formatting.length != textPieces.length) {
            return TextOps.withColor("unmatched format specifiers - this is a bug", 0xFF007F);
        }
        MutableComponent textBase = Component.m_237113_((String)textPieces[0]).m_130940_(formatting[0]);
        for (int i = 1; i < textPieces.length; ++i) {
            textBase.m_7220_((Component)Component.m_237113_((String)textPieces[i]).m_130940_(formatting[i]));
        }
        return textBase;
    }

    public static MutableComponent withColor(String text, int ... colors) {
        String[] textPieces = text.split("\u00a7");
        if (colors.length != textPieces.length) {
            return TextOps.withColor("unmatched color specifiers - this is a bug", 0xFF007F);
        }
        MutableComponent textBase = TextOps.withColor(textPieces[0], colors[0]);
        for (int i = 1; i < textPieces.length; ++i) {
            textBase.m_7220_((Component)TextOps.withColor(textPieces[i], colors[i]));
        }
        return textBase;
    }

    public static int width(Font renderer, Iterable<Component> texts) {
        int width = 0;
        for (Component text : texts) {
            width = Math.max(width, renderer.m_92852_((FormattedText)text));
        }
        return width;
    }

    public static int widthOrdered(Font renderer, Iterable<FormattedCharSequence> texts) {
        int width = 0;
        for (FormattedCharSequence text : texts) {
            width = Math.max(width, renderer.m_92724_(text));
        }
        return width;
    }

    public static int color(ChatFormatting formatting) {
        return formatting.m_126665_() == null ? 0 : formatting.m_126665_();
    }
}

