/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.registration.reflect;

import com.nyfaria.numismaticoverhaul.owostuff.registration.annotations.RegistryNamespace;
import com.nyfaria.numismaticoverhaul.owostuff.registration.reflect.AutoRegistryContainer;
import com.nyfaria.numismaticoverhaul.owostuff.registration.reflect.FieldProcessingSubject;
import com.nyfaria.numismaticoverhaul.owostuff.registration.reflect.SimpleFieldProcessingSubject;
import com.nyfaria.numismaticoverhaul.owostuff.util.ReflectionUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class FieldRegistrationHandler {
    public static <T> void process(Class<? extends FieldProcessingSubject<T>> clazz, ReflectionUtils.FieldConsumer<T> processor, boolean recurseIntoInnerClasses) {
        FieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(processor, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, FieldProcessingSubject.class, subclass -> FieldRegistrationHandler.process(subclass, processor, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void processSimple(Class<? extends SimpleFieldProcessingSubject<T>> clazz, boolean recurseIntoInnerClasses) {
        SimpleFieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(handler::processField, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, SimpleFieldProcessingSubject.class, subclass -> FieldRegistrationHandler.processSimple(subclass, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void register(Class<? extends AutoRegistryContainer<T>> clazz, String namespace, boolean recurseIntoInnerClasses) {
        AutoRegistryContainer container = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, container.getTargetFieldType(), FieldRegistrationHandler.createProcessor((fieldValue, identifier, field) -> {
            Registry.m_122965_(container.getRegistry(), (ResourceLocation)new ResourceLocation(namespace, identifier), (Object)fieldValue);
            container.postProcessField(namespace, fieldValue, identifier, field);
        }, container));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, AutoRegistryContainer.class, subclass -> {
                String classModId = namespace;
                if (subclass.isAnnotationPresent(RegistryNamespace.class)) {
                    classModId = subclass.getAnnotation(RegistryNamespace.class).value();
                }
                FieldRegistrationHandler.register(subclass, classModId, true);
            });
        }
        container.afterFieldProcessing();
    }

    private static <T> ReflectionUtils.FieldConsumer<T> createProcessor(ReflectionUtils.FieldConsumer<T> delegate, FieldProcessingSubject<T> handler) {
        return (value, name, field) -> {
            if (!handler.shouldProcessField(value, name, field)) {
                return;
            }
            delegate.accept(value, name, field);
        };
    }
}

