/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.renderdoc;

import com.nyfaria.numismaticoverhaul.owostuff.renderdoc.RenderdocLibrary;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.time.Instant;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.Util;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class RenderDoc {
    private static final RenderdocLibrary.RenderdocApi renderdoc;

    public static boolean isAvailable() {
        return renderdoc != null;
    }

    public static String getAPIVersion() {
        if (renderdoc == null) {
            return "not connected";
        }
        IntByReference major = new IntByReference();
        IntByReference minor = new IntByReference();
        IntByReference patch = new IntByReference();
        RenderDoc.renderdoc.GetAPIVersion.call(major, minor, patch);
        return major.getValue() + "." + minor.getValue() + "." + patch.getValue();
    }

    public static <T> boolean setCaptureOption(CaptureOption<T> option, T value) {
        if (renderdoc == null) {
            return false;
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return RenderDoc.renderdoc.SetCaptureOptionU32.call(option.idx, new RenderdocLibrary.uint32_t(bool != false ? 1 : 0)) == 1;
        }
        if (value instanceof Integer) {
            Integer uint = (Integer)value;
            return RenderDoc.renderdoc.SetCaptureOptionU32.call(option.idx, new RenderdocLibrary.uint32_t(uint)) == 1;
        }
        throw new UnsupportedOperationException();
    }

    public static <T> T getCaptureOption(CaptureOption<T> option) {
        if (renderdoc == null) {
            return null;
        }
        if (option.type == Boolean.class) {
            return (T)Boolean.valueOf(RenderDoc.renderdoc.GetCaptureOptionU32.call(option.idx).intValue() == 1);
        }
        if (option.type == Integer.class) {
            return (T)Integer.valueOf(RenderDoc.renderdoc.GetCaptureOptionU32.call(option.idx).intValue());
        }
        throw new UnsupportedOperationException();
    }

    public static void setCaptureKeys(Key ... keys) {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.SetCaptureKeys.call(Arrays.stream(keys).mapToInt(value -> value.keycode).toArray(), keys.length);
    }

    public static EnumSet<OverlayOption> getOverlayOptions() {
        if (renderdoc == null) {
            return null;
        }
        int mask = RenderDoc.renderdoc.GetOverlayBits.call().intValue();
        EnumSet<OverlayOption> set = EnumSet.noneOf(OverlayOption.class);
        for (OverlayOption option : OverlayOption.values()) {
            if ((mask & option.mask) == 0) continue;
            set.add(option);
        }
        return set;
    }

    public static void enableOverlayOptions(OverlayOption ... options) {
        if (renderdoc == null) {
            return;
        }
        int mask = 0;
        for (OverlayOption option : options) {
            mask |= option.mask;
        }
        RenderDoc.renderdoc.MaskOverlayBits.call(new RenderdocLibrary.uint32_t(-1), new RenderdocLibrary.uint32_t(mask));
    }

    public static void disableOverlayOptions(OverlayOption ... options) {
        if (renderdoc == null) {
            return;
        }
        int mask = 0;
        for (OverlayOption option : options) {
            mask |= option.mask;
        }
        RenderDoc.renderdoc.MaskOverlayBits.call(new RenderdocLibrary.uint32_t(~mask), new RenderdocLibrary.uint32_t(0));
    }

    public static void removeHooks() {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.RemoveHooks.call();
    }

    public static void unloadCrashHandler() {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.UnloadCrashHandler.call();
    }

    public static void setCaptureFilePathTemplate(String template) {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.SetCaptureFilePathTemplate.call(template);
    }

    public static String getCaptureFilePathTemplate() {
        if (renderdoc == null) {
            return null;
        }
        return RenderDoc.renderdoc.GetCaptureFilePathTemplate.call();
    }

    public static Capture getCapture(int index) {
        if (renderdoc == null) {
            return null;
        }
        IntByReference length = new IntByReference();
        if (RenderDoc.renderdoc.GetCapture.call(index, null, length, null).intValue() != 1) {
            return null;
        }
        byte[] filename = new byte[length.getValue()];
        LongByReference timestamp = new LongByReference();
        RenderDoc.renderdoc.GetCapture.call(index, filename, length, timestamp);
        return new Capture(new String(filename, 0, filename.length - 1), Instant.ofEpochSecond(timestamp.getValue()));
    }

    public static int getNumCaptures() {
        if (renderdoc == null) {
            return -1;
        }
        return RenderDoc.renderdoc.GetNumCaptures.call().intValue();
    }

    public static void triggerCapture() {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.TriggerCapture.call();
    }

    public static void startFrameCapture() {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.StartFrameCapture.call(null, null);
    }

    public static boolean isFrameCapturing() {
        if (renderdoc == null) {
            return false;
        }
        return RenderDoc.renderdoc.IsFrameCapturing.call().intValue() == 1;
    }

    public static void endFrameCapture() {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.EndFrameCapture.call(null, null);
    }

    public static boolean isReplayUIConnected() {
        if (renderdoc == null) {
            return false;
        }
        return RenderDoc.renderdoc.IsTargetControlConnected.call().intValue() == 1;
    }

    public static int launchReplayUI(boolean connect) {
        if (renderdoc == null) {
            return -1;
        }
        return RenderDoc.renderdoc.LaunchReplayUI.call(new RenderdocLibrary.uint32_t(connect ? 1 : 0), null).intValue();
    }

    public static boolean showReplayUI() {
        if (renderdoc == null) {
            return false;
        }
        return RenderDoc.renderdoc.ShowReplayUI.call().intValue() == 1;
    }

    public static void setCaptureComments(Capture capture, String comments) {
        if (renderdoc == null) {
            return;
        }
        RenderDoc.renderdoc.SetCaptureFileComments.call(capture.path, comments);
    }

    static {
        PointerByReference apiPointer = new PointerByReference();
        RenderdocLibrary.RenderdocApi apiInstance = null;
        Util.OS os = Util.m_137581_();
        if (os == Util.OS.WINDOWS || os == Util.OS.LINUX) {
            try {
                RenderdocLibrary renderdocLibrary = os == Util.OS.WINDOWS ? (RenderdocLibrary)Native.load((String)"renderdoc", RenderdocLibrary.class) : (RenderdocLibrary)Native.load((String)"renderdoc", RenderdocLibrary.class, Map.of("open-flags", 6));
                int initResult = renderdocLibrary.RENDERDOC_GetAPI(10500, apiPointer);
                if (initResult == 1) {
                    apiInstance = new RenderdocLibrary.RenderdocApi(apiPointer.getValue());
                    IntByReference major = new IntByReference();
                    IntByReference minor = new IntByReference();
                    IntByReference patch = new IntByReference();
                    apiInstance.GetAPIVersion.call(major, minor, patch);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        renderdoc = apiInstance;
    }

    public static final class CaptureOption<T> {
        public static final CaptureOption<Boolean> ALLOW_VSYNC = new CaptureOption<Boolean>(0, Boolean.class);
        public static final CaptureOption<Boolean> ALLOW_FULLSCREEN = new CaptureOption<Boolean>(1, Boolean.class);
        public static final CaptureOption<Boolean> API_VALIDATION = new CaptureOption<Boolean>(2, Boolean.class);
        public static final CaptureOption<Boolean> CAPTURE_CALLSTACKS = new CaptureOption<Boolean>(3, Boolean.class);
        public static final CaptureOption<Boolean> CAPTURE_CALLSTACKS_ONLY_DRAWS = new CaptureOption<Boolean>(4, Boolean.class);
        public static final CaptureOption<Integer> DELAY_FOR_DEBUGGER = new CaptureOption<Integer>(5, Integer.class);
        public static final CaptureOption<Boolean> VERIFY_BUFFER_ACCESS = new CaptureOption<Boolean>(6, Boolean.class);
        public static final CaptureOption<Boolean> HOOK_INTO_CHILDREN = new CaptureOption<Boolean>(7, Boolean.class);
        public static final CaptureOption<Boolean> REF_ALL_RESOURCES = new CaptureOption<Boolean>(8, Boolean.class);
        public static final CaptureOption<Boolean> SAVE_ALL_INITIALS = new CaptureOption<Boolean>(9, Boolean.class);
        public static final CaptureOption<Boolean> CAPTURE_ALL_CMD_LISTS = new CaptureOption<Boolean>(10, Boolean.class);
        public static final CaptureOption<Boolean> DEBUG_OUTPUT_MUTE = new CaptureOption<Boolean>(11, Boolean.class);
        @Deprecated
        public static final CaptureOption<?> ALLOW_UNSUPPORTED_VENDOR_EXTENSIONS = new CaptureOption<Void>(12, Void.class);
        public final int idx;
        private final Class<T> type;

        CaptureOption(int idx, Class<T> type) {
            this.idx = idx;
            this.type = type;
        }
    }

    public static enum OverlayOption {
        ENABLED(1),
        FRAME_RATE(2),
        FRAME_NUMBER(4),
        CAPTURE_LIST(8),
        DEFAULT(OverlayOption.ENABLED.mask | OverlayOption.FRAME_RATE.mask | OverlayOption.FRAME_NUMBER.mask | OverlayOption.CAPTURE_LIST.mask),
        ALL(-1),
        NONE(0);

        public final int mask;

        private OverlayOption(int mask) {
            this.mask = mask;
        }
    }

    public record Capture(String path, Instant timestamp) {
    }

    public static enum Key {
        ZERO(48, 48),
        ONE(49, 49),
        TWO(50, 50),
        THREE(51, 50),
        FOUR(52, 52),
        FIVE(53, 53),
        SIX(54, 54),
        SEVEN(55, 55),
        EIGHT(56, 56),
        NINE(57, 57),
        A(65, 65),
        B(66, 66),
        C(67, 67),
        D(68, 68),
        E(69, 69),
        F(70, 70),
        G(71, 71),
        H(72, 72),
        I(73, 73),
        J(74, 74),
        K(75, 75),
        L(76, 76),
        M(77, 77),
        N(78, 78),
        O(79, 79),
        P(80, 80),
        Q(81, 81),
        R(82, 82),
        S(83, 83),
        T(84, 84),
        U(85, 85),
        V(86, 86),
        W(87, 87),
        X(88, 88),
        Y(89, 89),
        Z(90, 90),
        NON_PRINTABLE(256, -1),
        DIVIDE(257, 331),
        MULTIPLY(258, 332),
        SUBTRACT(259, 333),
        PLUS(260, 334),
        F1(261, 290),
        F2(262, 291),
        F3(263, 292),
        F4(264, 293),
        F5(265, 294),
        F6(266, 295),
        F7(267, 296),
        F8(268, 297),
        F9(269, 298),
        F10(270, 299),
        F11(271, 300),
        F12(272, 301),
        HOME(273, 268),
        END(274, 269),
        INSERT(275, 260),
        DELETE(276, 261),
        PAGE_UP(277, 266),
        PAGE_DOWN(278, 267),
        BACKSPACE(279, 259),
        TAB(280, 258),
        PRINT_SCREEN(281, 283),
        PAUSE(282, 284);

        private final int keycode;
        private final int glfw;
        private static final Int2ObjectMap<Key> GLFW_MAPPINGS;

        private Key(int keycode, int glfw) {
            this.keycode = keycode;
            this.glfw = glfw;
        }

        @Nullable
        public static Key fromGLFW(int glfw) {
            return (Key)((Object)GLFW_MAPPINGS.getOrDefault(glfw, null));
        }

        static {
            GLFW_MAPPINGS = new Int2ObjectOpenHashMap();
            for (Key key : Key.values()) {
                if (key.glfw < 0) continue;
                GLFW_MAPPINGS.put(key.glfw, (Object)key);
            }
        }
    }
}

