/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.component;

import com.nyfaria.numismaticoverhaul.owostuff.ui.component.BlockComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.BoxComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.ButtonComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.CheckboxComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.DiscreteSliderComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.DropdownComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.EntityComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.ItemComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.LabelComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.ModEditBox;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.SliderComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.SpriteComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.TextureComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.TexturedButtonComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.VanillaWidgetComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.Containers;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.FlowLayout;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Components {
    public static TexturedButtonComponent texturedButton(ResourceLocation texture, Component message, int width, int height, int u, int v, int textureWidth, int textureHeight, Button.OnPress onPress) {
        return new TexturedButtonComponent(texture, width, height, u, v, textureWidth, textureHeight, message, onPress);
    }

    public static TexturedButtonComponent texturedButton(ResourceLocation texture, Component message, int width, int height, int u, int v, Button.OnPress onPress) {
        return new TexturedButtonComponent(texture, width, height, u, v, 256, 256, message, onPress);
    }

    @Deprecated(forRemoval=true)
    public static Button button(Component message, int width, int height, Button.OnPress onPress) {
        return Components.createWithSizing(() -> new ButtonComponent(message, arg_0 -> ((Button.OnPress)onPress).m_93750_(arg_0)), Sizing.fixed(width), Sizing.fixed(height));
    }

    @Deprecated(forRemoval=true)
    public static Button button(Component message, Button.OnPress onPress) {
        ButtonComponent button = new ButtonComponent(message, arg_0 -> ((Button.OnPress)onPress).m_93750_(arg_0));
        button.sizing(Sizing.content(1), Sizing.content());
        return button;
    }

    public static ButtonComponent button(Component message, Consumer<ButtonComponent> onPress) {
        ButtonComponent button = new ButtonComponent(message, onPress);
        button.sizing(Sizing.content(1), Sizing.content());
        return button;
    }

    public static EditBox textBox(Sizing horizontalSizing) {
        return Components.createWithSizing(() -> new ModEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, (Component)Component.m_237119_()), horizontalSizing, Sizing.fixed(20));
    }

    public static EditBox textBox(Sizing horizontalSizing, String text) {
        EditBox textBox = Components.textBox(horizontalSizing);
        textBox.m_94144_(text);
        textBox.m_94198_();
        return textBox;
    }

    public static <E extends Entity> EntityComponent<E> entity(Sizing sizing, EntityType<E> type, @Nullable CompoundTag nbt) {
        return new EntityComponent<E>(sizing, type, nbt);
    }

    public static <E extends Entity> EntityComponent<E> entity(Sizing sizing, E entity) {
        return new EntityComponent<E>(sizing, entity);
    }

    public static ItemComponent item(ItemStack item) {
        return new ItemComponent(item);
    }

    public static BlockComponent block(BlockState state) {
        return new BlockComponent(state, null);
    }

    public static BlockComponent block(BlockState state, BlockEntity blockEntity) {
        return new BlockComponent(state, blockEntity);
    }

    public static BlockComponent block(BlockState state, @Nullable CompoundTag nbt) {
        Minecraft client = Minecraft.m_91087_();
        BlockEntity blockEntity = null;
        Block block = state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock provider = (EntityBlock)block;
            blockEntity = provider.m_142194_(client.f_91074_.m_20183_(), state);
            BlockComponent.prepareBlockEntity(state, blockEntity, nbt);
        }
        return new BlockComponent(state, blockEntity);
    }

    public static LabelComponent label(Component text) {
        return new LabelComponent(text);
    }

    public static CheckboxComponent checkbox(Component message) {
        return new CheckboxComponent(message);
    }

    public static SliderComponent slider(Sizing horizontalSizing) {
        return new SliderComponent(horizontalSizing);
    }

    public static DiscreteSliderComponent discreteSlider(Sizing horizontalSizing, double min, double max) {
        return new DiscreteSliderComponent(horizontalSizing, min, max);
    }

    public static SpriteComponent sprite(Material spriteId) {
        return new SpriteComponent(spriteId.m_119204_());
    }

    public static SpriteComponent sprite(TextureAtlasSprite sprite) {
        return new SpriteComponent(sprite);
    }

    public static TextureComponent texture(ResourceLocation texture, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        return new TextureComponent(texture, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public static TextureComponent texture(ResourceLocation texture, int u, int v, int regionWidth, int regionHeight) {
        return new TextureComponent(texture, u, v, regionWidth, regionHeight, 256, 256);
    }

    public static BoxComponent box(Sizing horizontalSizing, Sizing verticalSizing) {
        return new BoxComponent(horizontalSizing, verticalSizing);
    }

    public static DropdownComponent dropdown(Sizing horizontalSizing) {
        return new DropdownComponent(horizontalSizing);
    }

    public static <T, C extends ModComponent> FlowLayout list(List<T> data, Consumer<FlowLayout> layoutConfigurator, Function<T, C> componentMaker, boolean vertical) {
        FlowLayout layout = vertical ? Containers.verticalFlow(Sizing.content(), Sizing.content()) : Containers.horizontalFlow(Sizing.content(), Sizing.content());
        layoutConfigurator.accept(layout);
        for (T value : data) {
            layout.child((ModComponent)componentMaker.apply(value));
        }
        return layout;
    }

    public static VanillaWidgetComponent wrapVanillaWidget(AbstractWidget widget) {
        return new VanillaWidgetComponent(widget);
    }

    public static <T extends ModComponent> T createWithSizing(Supplier<T> componentMaker, Sizing horizontalSizing, Sizing verticalSizing) {
        ModComponent component = (ModComponent)componentMaker.get();
        component.sizing(horizontalSizing, verticalSizing);
        return (T)component;
    }
}

