/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.container;

import com.nyfaria.numismaticoverhaul.owostuff.ui.container.FlowLayout;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.HorizontalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.VerticalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.MountingHelper;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableInt;

public class VerticalFlowLayout
extends FlowLayout {
    protected VerticalFlowLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    @Override
    public void layout(Size space) {
        MutableInt layoutHeight = new MutableInt(0);
        MutableInt layoutWidth = new MutableInt(0);
        ArrayList layout = new ArrayList();
        Insets padding = (Insets)this.padding.get();
        Size childSpace = this.calculateChildSpace(space);
        MountingHelper mountState = MountingHelper.mountEarly((x$0, x$1, x$2) -> this.mountChild(x$0, x$1, x$2), this.children, childSpace, child -> {
            layout.add(child);
            child.inflate(childSpace);
            child.mount(this, this.x + padding.left() + ((Insets)child.margins().get()).left(), this.y + padding.top() + ((Insets)child.margins().get()).top() + layoutHeight.intValue());
            Size childSize = child.fullSize();
            layoutHeight.add(childSize.height());
            if (childSize.width() > layoutWidth.intValue()) {
                layoutWidth.setValue(childSize.width());
            }
        });
        this.contentSize = Size.of(layoutWidth.intValue(), layoutHeight.intValue());
        if (((Sizing)this.horizontalSizing.get()).method == Sizing.Method.CONTENT) {
            this.applyHorizontalContentSizing((Sizing)this.horizontalSizing.get());
        }
        if (((Sizing)this.verticalSizing.get()).method == Sizing.Method.CONTENT) {
            this.applyVerticalContentSizing((Sizing)this.verticalSizing.get());
        }
        if (this.horizontalAlignment() != HorizontalAlignment.LEFT) {
            for (ModComponent component : layout) {
                component.setX(component.x() + this.horizontalAlignment().align(component.fullSize().width(), this.width - padding.horizontal()));
            }
        }
        if (this.verticalAlignment() != VerticalAlignment.TOP) {
            for (ModComponent component : layout) {
                if (this.verticalAlignment() == VerticalAlignment.CENTER) {
                    component.setY(component.y() + (this.height - padding.vertical() - layoutHeight.intValue()) / 2);
                    continue;
                }
                component.setY(component.y() + (this.height - padding.vertical() - layoutHeight.intValue()));
            }
        }
        mountState.mountLate();
    }
}

