/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.event;

import com.nyfaria.numismaticoverhaul.owostuff.ui.event.CharTyped;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.FocusGained;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.FocusLost;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.KeyPress;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseDown;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseDrag;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseEnter;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseLeave;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseScroll;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseUp;
import com.nyfaria.numismaticoverhaul.owostuff.util.EventStream;

public class UIEvents {
    public static EventStream<MouseDown> newMouseDownStream() {
        return new EventStream<MouseDown>(subscribers -> (mouseX, mouseY, button) -> {
            boolean anyTriggered = false;
            for (MouseDown subscriber : subscribers) {
                anyTriggered |= subscriber.onMouseDown(mouseX, mouseY, button);
            }
            return anyTriggered;
        });
    }

    public static EventStream<MouseUp> newMouseUpStream() {
        return new EventStream<MouseUp>(subscribers -> (mouseX, mouseY, button) -> {
            boolean anyTriggered = false;
            for (MouseUp subscriber : subscribers) {
                anyTriggered |= subscriber.onMouseUp(mouseX, mouseY, button);
            }
            return anyTriggered;
        });
    }

    public static EventStream<MouseScroll> newMouseScrollStream() {
        return new EventStream<MouseScroll>(subscribers -> (mouseX, mouseY, amount) -> {
            boolean anyTriggered = false;
            for (MouseScroll subscriber : subscribers) {
                anyTriggered |= subscriber.onMouseScroll(mouseX, mouseY, amount);
            }
            return anyTriggered;
        });
    }

    public static EventStream<MouseDrag> newMouseDragStream() {
        return new EventStream<MouseDrag>(subscribers -> (mouseX, mouseY, deltaX, deltaY, button) -> {
            boolean anyTriggered = false;
            for (MouseDrag subscriber : subscribers) {
                anyTriggered |= subscriber.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            }
            return anyTriggered;
        });
    }

    public static EventStream<KeyPress> newKeyPressStream() {
        return new EventStream<KeyPress>(subscribers -> (keyCode, scanCode, modifiers) -> {
            boolean anyTriggered = false;
            for (KeyPress subscriber : subscribers) {
                anyTriggered |= subscriber.onKeyPress(keyCode, scanCode, modifiers);
            }
            return anyTriggered;
        });
    }

    public static EventStream<CharTyped> newCharTypedStream() {
        return new EventStream<CharTyped>(subscribers -> (chr, modifiers) -> {
            boolean anyTriggered = false;
            for (CharTyped subscriber : subscribers) {
                anyTriggered |= subscriber.onCharTyped(chr, modifiers);
            }
            return anyTriggered;
        });
    }

    public static EventStream<FocusGained> newFocusGainedStream() {
        return new EventStream<FocusGained>(subscribers -> source -> {
            for (FocusGained subscriber : subscribers) {
                subscriber.onFocusGained(source);
            }
        });
    }

    public static EventStream<FocusLost> newFocusLostStream() {
        return new EventStream<FocusLost>(subscribers -> () -> {
            for (FocusLost subscriber : subscribers) {
                subscriber.onFocusLost();
            }
        });
    }

    public static EventStream<MouseEnter> newMouseEnterStream() {
        return new EventStream<MouseEnter>(subscribers -> () -> {
            for (MouseEnter subscriber : subscribers) {
                subscriber.onMouseEnter();
            }
        });
    }

    public static EventStream<MouseLeave> newMouseLeaveStream() {
        return new EventStream<MouseLeave>(subscribers -> () -> {
            for (MouseLeave subscriber : subscribers) {
                subscriber.onMouseLeave();
            }
        });
    }
}

