/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.nyfaria.numismaticoverhaul.mixin.owomixins.ui.ScreenInvoker;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.OwoNinePatchRenderers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Drawer
extends GuiComponent {
    private static boolean recording = false;
    private static final Drawer INSTANCE = new Drawer();
    private final DebugDrawer debug = new DebugDrawer();
    public static final ResourceLocation PANEL_TEXTURE = new ResourceLocation("owo", "textures/gui/panel.png");
    public static final ResourceLocation DARK_PANEL_TEXTURE = new ResourceLocation("owo", "textures/gui/dark_panel.png");

    private Drawer() {
    }

    public static void drawRectOutline(PoseStack matrices, int x, int y, int width, int height, int color) {
        Drawer.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)color);
        Drawer.m_93172_((PoseStack)matrices, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)color);
        Drawer.m_93172_((PoseStack)matrices, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)color);
        Drawer.m_93172_((PoseStack)matrices, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)color);
    }

    public static void drawGradientRect(PoseStack matrices, int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(matrix, (float)(x + width), (float)y, 0.0f).m_193479_(topRightColor).m_5752_();
        buffer.m_85982_(matrix, (float)x, (float)y, 0.0f).m_193479_(topLeftColor).m_5752_();
        buffer.m_85982_(matrix, (float)x, (float)(y + height), 0.0f).m_193479_(bottomLeftColor).m_5752_();
        buffer.m_85982_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_193479_(bottomRightColor).m_5752_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawPanel(PoseStack matrices, int x, int y, int width, int height, boolean dark) {
        (dark ? OwoNinePatchRenderers.DARK_PANEL : OwoNinePatchRenderers.LIGHT_PANEL).draw(matrices, x, y, width, height);
    }

    public static void drawText(PoseStack matrices, Component text, float x, float y, float scale, int color) {
        Drawer.drawText(matrices, text, x, y, scale, color, TextAnchor.TOP_LEFT);
    }

    public static void drawText(PoseStack matrices, Component text, float x, float y, float scale, int color, TextAnchor anchorPoint) {
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        matrices.m_85836_();
        matrices.m_85841_(scale, scale, 1.0f);
        switch (anchorPoint) {
            case TOP_RIGHT: {
                x -= (float)textRenderer.m_92852_((FormattedText)text) * scale;
                break;
            }
            case BOTTOM_LEFT: {
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
                break;
            }
            case BOTTOM_RIGHT: {
                x -= (float)textRenderer.m_92852_((FormattedText)text) * scale;
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
            }
        }
        textRenderer.m_92889_(matrices, text, x * (1.0f / scale), y * (1.0f / scale), color);
        matrices.m_85849_();
    }

    public static void drawTooltip(PoseStack matrices, int x, int y, List<ClientTooltipComponent> tooltip) {
        ((ScreenInvoker)((Object)Drawer.utilityScreen())).owo$renderTooltipFromComponents(matrices, tooltip, x, y);
    }

    public static UtilityScreen utilityScreen() {
        return UtilityScreen.get();
    }

    public static DebugDrawer debug() {
        return Drawer.INSTANCE.debug;
    }

    public static void recordQuads() {
        recording = true;
    }

    public static boolean recording() {
        return recording;
    }

    public static void submitQuads() {
        recording = false;
        Tesselator.m_85913_().m_85914_();
    }

    public static class DebugDrawer {
        private DebugDrawer() {
        }

        public void drawInsets(PoseStack matrices, int x, int y, int width, int height, Insets insets, int color) {
            GuiComponent.m_93172_((PoseStack)matrices, (int)(x - insets.left()), (int)(y - insets.top()), (int)(x + width + insets.right()), (int)y, (int)color);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(x - insets.left()), (int)(y + height), (int)(x + width + insets.right()), (int)(y + height + insets.bottom()), (int)color);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(x - insets.left()), (int)y, (int)x, (int)(y + height), (int)color);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(x + width), (int)y, (int)(x + width + insets.right()), (int)(y + height), (int)color);
        }

        public void drawInspector(PoseStack matrices, ParentComponent root, double mouseX, double mouseY, boolean onlyHovered) {
            RenderSystem.m_69465_();
            Minecraft client = Minecraft.m_91087_();
            Font textRenderer = client.f_91062_;
            ArrayList<ModComponent> children = new ArrayList<ModComponent>();
            if (!onlyHovered) {
                root.collectChildren(children);
            } else if (root.childAt((int)mouseX, (int)mouseY) != null) {
                children.add(root.childAt((int)mouseX, (int)mouseY));
            }
            for (ModComponent child : children) {
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    this.drawInsets(matrices, parentComponent.x(), parentComponent.y(), parentComponent.width(), parentComponent.height(), ((Insets)parentComponent.padding().get()).inverted(), -1492325155);
                }
                Insets margins = (Insets)child.margins().get();
                this.drawInsets(matrices, child.x(), child.y(), child.width(), child.height(), margins, -1476398280);
                Drawer.drawRectOutline(matrices, child.x(), child.y(), child.width(), child.height(), -12930817);
                if (!onlyHovered) continue;
                int inspectorX = child.x() + 1;
                int inspectorY = child.y() + child.height() + ((Insets)child.margins().get()).bottom() + 1;
                Objects.requireNonNull(textRenderer);
                int inspectorHeight = 9 * 2 + 4;
                if (inspectorY > client.m_91268_().m_85446_() - inspectorHeight) {
                    if ((inspectorY -= child.fullSize().height() + inspectorHeight + 1) < 0) {
                        inspectorY = 1;
                    }
                    if (child instanceof ParentComponent) {
                        ParentComponent parentComponent = (ParentComponent)child;
                        inspectorX += ((Insets)parentComponent.padding().get()).left();
                        inspectorY += ((Insets)parentComponent.padding().get()).top();
                    }
                }
                Component nameText = Component.m_130674_((String)(child.getClass().getSimpleName() + (String)(child.id() != null ? " '" + child.id() + "'" : "")));
                MutableComponent descriptor = Component.m_237113_((String)(child.x() + "," + child.y() + " (" + child.width() + "," + child.height() + ") <" + margins.top() + "," + margins.bottom() + "," + margins.left() + "," + margins.right() + "> "));
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    Insets padding = (Insets)parentComponent.padding().get();
                    descriptor.m_130946_(" >" + padding.top() + "," + padding.bottom() + "," + padding.left() + "," + padding.right() + "<");
                }
                int width = Math.max(textRenderer.m_92852_((FormattedText)nameText), textRenderer.m_92852_((FormattedText)descriptor));
                GuiComponent.m_93172_((PoseStack)matrices, (int)inspectorX, (int)inspectorY, (int)(inspectorX + width + 3), (int)(inspectorY + inspectorHeight), (int)-1493172224);
                Drawer.drawRectOutline(matrices, inspectorX, inspectorY, width + 3, inspectorHeight, -1493172224);
                textRenderer.m_92889_(matrices, nameText, (float)(inspectorX + 2), (float)(inspectorY + 2), 0xFFFFFF);
                float f = inspectorX + 2;
                Objects.requireNonNull(textRenderer);
                textRenderer.m_92889_(matrices, (Component)descriptor, f, (float)(inspectorY + 9 + 2), 0xFFFFFF);
            }
            RenderSystem.m_69482_();
        }
    }

    public static enum TextAnchor {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }

    public static class UtilityScreen
    extends Screen {
        private static UtilityScreen INSTANCE;

        private UtilityScreen() {
            super((Component)Component.m_237119_());
        }

        public void m_96570_(PoseStack matrices, @Nullable Style style, int x, int y) {
            super.m_96570_(matrices, style, x, y);
        }

        public static UtilityScreen get() {
            if (INSTANCE == null) {
                INSTANCE = new UtilityScreen();
                Minecraft client = Minecraft.m_91087_();
                INSTANCE.m_6575_(client, client.m_91268_().m_85445_(), client.m_91268_().m_85446_());
            }
            return INSTANCE;
        }
    }
}

