/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.PositionedRectangle;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class ScissorStack {
    private static final PoseStack EMPTY_STACK = new PoseStack();
    private static final Deque<PositionedRectangle> STACK = new ArrayDeque<PositionedRectangle>();

    public static void pushDirect(int x, int y, int width, int height) {
        Window window = Minecraft.m_91087_().m_91268_();
        double scale = window.m_85449_();
        ScissorStack.push((int)((double)x / scale), (int)((double)window.m_85446_() - (double)y / scale - (double)height / scale), (int)((double)width / scale), (int)((double)height / scale), null);
    }

    public static void push(int x, int y, int width, int height, @Nullable PoseStack matrices) {
        PositionedRectangle newFrame = ScissorStack.withGlTransform(x, y, width, height, matrices);
        if (STACK.isEmpty()) {
            STACK.push(newFrame);
        } else {
            PositionedRectangle top = STACK.peek();
            STACK.push(top.intersection(newFrame));
        }
        ScissorStack.applyState();
    }

    public static void pop() {
        if (STACK.isEmpty()) {
            throw new IllegalStateException("Cannot pop frame from empty scissor stack");
        }
        STACK.pop();
        if (STACK.isEmpty()) {
            Window window = Minecraft.m_91087_().m_91268_();
            GL11.glScissor((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        } else {
            ScissorStack.applyState();
        }
    }

    private static void applyState() {
        if (!GL11.glIsEnabled((int)3089)) {
            return;
        }
        PositionedRectangle newFrame = STACK.peek();
        Window window = Minecraft.m_91087_().m_91268_();
        double scale = window.m_85449_();
        GL11.glScissor((int)((int)((double)newFrame.x() * scale)), (int)((int)((double)window.m_85442_() - (double)newFrame.y() * scale - (double)newFrame.height() * scale)), (int)((int)((double)newFrame.width() * scale)), (int)((int)((double)newFrame.height() * scale)));
    }

    public static void drawUnclipped(Runnable action) {
        boolean scissorEnabled = GL11.glIsEnabled((int)3089);
        if (scissorEnabled) {
            GlStateManager.m_84495_();
        }
        action.run();
        if (scissorEnabled) {
            GlStateManager.m_84501_();
        }
    }

    public static boolean isVisible(int x, int y, @Nullable PoseStack matrices) {
        PositionedRectangle top = STACK.peek();
        if (top == null) {
            return true;
        }
        return top.intersects(ScissorStack.withGlTransform(x, y, 0, 0, matrices));
    }

    public static boolean isVisible(ModComponent component, @Nullable PoseStack matrices) {
        PositionedRectangle top = STACK.peek();
        if (top == null) {
            return true;
        }
        Insets margins = (Insets)component.margins().get();
        return top.intersects(ScissorStack.withGlTransform(component.x() - margins.left(), component.y() - margins.top(), component.width() + margins.right(), component.height() + margins.bottom(), matrices));
    }

    private static PositionedRectangle withGlTransform(int x, int y, int width, int height, @Nullable PoseStack matrices) {
        if (matrices == null) {
            matrices = EMPTY_STACK;
        }
        matrices.m_85836_();
        matrices.m_166854_(RenderSystem.m_157190_());
        Vector4f root = new Vector4f((float)x, (float)y, 0.0f, 1.0f);
        Vector4f end = new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f);
        root.m_123607_(matrices.m_85850_().m_85861_());
        end.m_123607_(matrices.m_85850_().m_85861_());
        x = (int)root.m_123601_();
        y = (int)root.m_123615_();
        width = (int)Math.ceil(end.m_123601_() - root.m_123601_());
        height = (int)Math.ceil(end.m_123615_() - root.m_123615_());
        matrices.m_85849_();
        return PositionedRectangle.of(x, y, width, height);
    }
}

