/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.util;

import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RegistryAccess {
    private RegistryAccess() {
    }

    @Nullable
    public static <T> Holder<T> getEntry(Registry<T> registry, ResourceLocation id) {
        RegistryAccess.checkSimple(registry);
        return ((AccessibleRegistry)registry).getEntry(id);
    }

    @Nullable
    public static <T> Holder<T> getEntry(Registry<T> registry, T value) {
        RegistryAccess.checkSimple(registry);
        return ((AccessibleRegistry)registry).getEntry(value);
    }

    private static void checkSimple(Registry<?> registry) {
        if (registry instanceof MappedRegistry) {
            return;
        }
        throw new IllegalArgumentException("[RegistryAccess] Tried to operate on Registry of class '" + registry.getClass() + "', but only 'SimpleRegistry' and descendants are supported");
    }

    public static interface AccessibleRegistry<T> {
        @Nullable
        public Holder<T> getEntry(ResourceLocation var1);

        @Nullable
        public Holder<T> getEntry(T var1);
    }
}

