/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json.adapters;

import com.google.gson.JsonObject;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.VillagerJsonHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.NumOTrade;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.NotNull;

public class SellStackAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json, true);
        VillagerJsonHelper.assertJsonObject(json, "sell");
        ItemStack sell = VillagerJsonHelper.getItemStackFromJson(json.get("sell").getAsJsonObject());
        int price = json.get("price").getAsInt();
        return new Factory(sell, price, this.max_uses, this.villager_experience, this.price_multiplier);
    }

    private static class Factory
    implements VillagerTrades.ItemListing,
    NumOTrade {
        private final ItemStack sell;
        private final int maxUses;
        private final int experience;
        private final int price;
        private final float multiplier;

        public Factory(ItemStack sell, int price, int maxUses, int experience, float multiplier) {
            this.sell = sell;
            this.maxUses = maxUses;
            this.experience = experience;
            this.price = price;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(CurrencyHelper.getClosest(this.price), this.sell, this.maxUses, this.experience, this.multiplier);
        }
    }
}

