/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.commands;

import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandSetNutrient {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"set_nutrient").requires(cs -> cs.m_6761_(3))).then(Commands.m_82129_((String)"nutrient", (ArgumentType)new NutrientStringArgumentType()).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)180.0f)).executes(ctx -> CommandSetNutrient.setNutrients((CommandContext<CommandSourceStack>)ctx))));
    }

    public static int setNutrients(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            INutritionalBalancePlayer iNutritionalBalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer(player);
            String nutrientName = (String)context.getArgument("nutrient", String.class);
            float value = FloatArgumentType.getFloat(context, (String)"value");
            iNutritionalBalancePlayer.getPlayerNutrientByName(nutrientName).setValue(value);
        }
        return 0;
    }

    public static class NutrientStringArgumentType
    implements ArgumentType<String> {
        private List<String> nutrientList = new ArrayList<String>();

        public String parse(StringReader reader) throws CommandSyntaxException {
            String string = reader.readString();
            if (this.getNutrientList().contains(string)) {
                return string;
            }
            SimpleCommandExceptionType exceptionType = new SimpleCommandExceptionType(new Message(){

                public String getString() {
                    return "Invalid nutrient argument";
                }
            });
            throw exceptionType.create();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82970_(this.getNutrientList(), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            return this.getNutrientList();
        }

        private List<String> getNutrientList() {
            if (this.nutrientList.size() == 0) {
                List<Nutrient> nutrients = WorldNutrients.get();
                for (Nutrient nutrient : nutrients) {
                    this.nutrientList.add(nutrient.name);
                }
            }
            return this.nutrientList;
        }

        private void setNutrientList(List<String> nutrientList) {
            this.nutrientList = nutrientList;
        }

        public static class Serializer
        implements ArgumentTypeInfo<NutrientStringArgumentType, Template> {
            public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
                buffer.m_130070_(String.join((CharSequence)"!!", template.getNutrientStringArgumentType().getNutrientList()));
            }

            public void serializeToJson(Template template, JsonObject json) {
                json.addProperty("nutrient_string_argument", String.join((CharSequence)"!!", template.getNutrientStringArgumentType().getNutrientList()));
            }

            public Template unpack(NutrientStringArgumentType nutrientStringArgumentType) {
                return new Template(nutrientStringArgumentType);
            }

            public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
                List<String> nutrientList = Arrays.stream(buffer.m_130277_().split("!!")).toList();
                NutrientStringArgumentType nutrientStringArgumentType = new NutrientStringArgumentType();
                nutrientStringArgumentType.setNutrientList(nutrientList);
                return new Template(nutrientStringArgumentType);
            }

            public final class Template
            implements ArgumentTypeInfo.Template<NutrientStringArgumentType> {
                NutrientStringArgumentType nutrientStringArgumentType;

                Template(NutrientStringArgumentType type) {
                    this.nutrientStringArgumentType = type;
                }

                public NutrientStringArgumentType instantiate(CommandBuildContext p_235378_) {
                    return this.nutrientStringArgumentType;
                }

                public ArgumentTypeInfo<NutrientStringArgumentType, ?> m_213709_() {
                    return Serializer.this;
                }

                public NutrientStringArgumentType getNutrientStringArgumentType() {
                    return this.nutrientStringArgumentType;
                }
            }
        }
    }
}

