/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.gui;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.gui.INutrientGUIScreen;
import com.dannyandson.nutritionalbalance.gui.ModWidget;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class NutrientGUIHelper {
    public static void init(INutrientGUIScreen screen, int guiWidth, int guiHeight) {
        NutrientGUIHelper.init(screen, guiWidth, guiHeight, 0);
    }

    public static void init(INutrientGUIScreen screen, int guiWidth, int guiHeight, int yOffset) {
        int messageColor;
        MutableComponent message;
        int screenWidth = screen.getWidth();
        int screenHeight = screen.getHeight();
        INutritionalBalancePlayer iNutritionalBalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer((Player)screen.getMinecraft().f_91074_);
        int maxColumnHeight = 7;
        int labelWidth = 50;
        int columnWidth = guiWidth - labelWidth - 30;
        int colorColumnBackground = 0;
        int colorNutrientValueFill = -16763905;
        int colorTargetIndicator = -1727987968;
        int colorUnsafeIndicator = -1711341568;
        int relX = (screenWidth - guiWidth) / 2;
        int relY = (screenHeight - guiHeight) / 2 + yOffset;
        screen.addModWidget(new ModWidget(relX, relY + 5, guiWidth, 10, (Component)Component.m_237115_((String)"nutritionalbalance.nutrients"), -16777216).setTextHAlignment(ModWidget.HAlignment.CENTER).setTextVAlignment(ModWidget.VAlignment.TOP));
        if (iNutritionalBalancePlayer.getCachedStatus() == IPlayerNutrient.NutrientStatus.ON_TARGET) {
            message = Component.m_237115_((String)"nutritionalbalance.nutrientstatus.details.ON_TARGET");
            messageColor = -16742400;
        } else if (iNutritionalBalancePlayer.getCachedStatus() == IPlayerNutrient.NutrientStatus.ENGORGED) {
            message = Component.m_237115_((String)"nutritionalbalance.nutrientstatus.details.ENGORGED");
            messageColor = -7864320;
        } else if (iNutritionalBalancePlayer.getCachedStatus() == IPlayerNutrient.NutrientStatus.MALNOURISHED) {
            message = Component.m_237115_((String)"nutritionalbalance.nutrientstatus.details.MALNOURISHED");
            messageColor = -7864320;
        } else {
            message = Component.m_237115_((String)"nutritionalbalance.nutrientstatus.details.SAFE");
            messageColor = -16759808;
        }
        screen.addModWidget(new ModWidget(relX, relY + 18, guiWidth, 10, (Component)message, messageColor).setTextHAlignment(ModWidget.HAlignment.CENTER).setTextVAlignment(ModWidget.VAlignment.TOP));
        int nutrientcount = iNutritionalBalancePlayer.getPlayerNutrients().size();
        if (nutrientcount > 0) {
            int nBlocksOffset = 35;
            int nBlockHeight = (guiHeight - nBlocksOffset - 30) / nutrientcount;
            int columnHeight = Math.min(maxColumnHeight, nBlockHeight - 2);
            int columnBlockRelX = relX + 10;
            int columnDrawY = relY + nBlocksOffset + nBlockHeight * (nutrientcount - 1);
            int engorged_bottom = Math.round(((Double)Config.NUTRIENT_ENGORGED.get()).floatValue() / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnWidth);
            int target_top = Math.round(((Double)Config.NUTRIENT_TARGET_HIGH.get()).floatValue() / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnWidth);
            int target_bottom = Math.round(((Double)Config.NUTRIENT_LOW_TARGET.get()).floatValue() / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnWidth);
            int malnourished_top = Math.round(((Double)Config.NUTRIENT_MALNOURISHED.get()).floatValue() / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnWidth);
            for (IPlayerNutrient playerNutrient : iNutritionalBalancePlayer.getPlayerNutrients()) {
                int columnRelY = columnDrawY;
                int nutrientValueWidth = Math.round(playerNutrient.getValue() / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnWidth);
                boolean nonEssentialNutrient = false;
                for (String badNutrientName : (List)Config.BAD_NUTRIENTS.get()) {
                    if (!badNutrientName.equals(playerNutrient.getNutrientName())) continue;
                    nonEssentialNutrient = true;
                }
                boolean goodNutrient = false;
                for (String goodNutrientName : (List)Config.GOOD_NUTRIENTS.get()) {
                    if (!goodNutrientName.equals(playerNutrient.getNutrientName())) continue;
                    goodNutrient = true;
                }
                screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth - 1, columnRelY - 1, columnWidth + 2, columnHeight + 2, -16777216));
                screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth, columnRelY, columnWidth, columnHeight, colorColumnBackground));
                screen.addModWidget(new ModWidget(columnBlockRelX, columnDrawY, labelWidth, 10, (Component)Component.m_237115_((String)("nutritionalbalance.nutrient." + playerNutrient.getNutrientName())), -16777216));
                screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth, columnRelY, nutrientValueWidth, columnHeight, colorNutrientValueFill)).setToolTip(Component.m_130674_((String)((float)Math.round(playerNutrient.getValue() * 10.0f) / 10.0f + "NU")));
                if (nonEssentialNutrient) {
                    screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth, columnRelY - 1, 1, columnHeight + 2, colorTargetIndicator)).setToolTip(Component.m_130674_((String)"Target: 0NU"));
                } else {
                    screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth + malnourished_top, columnRelY - 1, 1, columnHeight + 2, colorUnsafeIndicator)).setToolTip(Component.m_130674_((String)("Malnourishment: " + ((Double)Config.NUTRIENT_MALNOURISHED.get()).toString() + "NU")));
                    screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth + target_bottom, columnRelY - 1, 1, columnHeight + 2, colorTargetIndicator)).setToolTip(Component.m_130674_((String)("Target: " + ((Double)Config.NUTRIENT_LOW_TARGET.get()).toString() + "NU")));
                }
                if (goodNutrient) {
                    screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth + columnWidth, columnRelY - 1, 1, columnHeight + 2, colorTargetIndicator)).setToolTip(Component.m_130674_((String)"Target Cap: \u221eNU"));
                } else {
                    screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth + engorged_bottom, columnRelY - 1, 1, columnHeight + 1, colorUnsafeIndicator)).setToolTip(Component.m_130674_((String)("Engorgement: " + ((Double)Config.NUTRIENT_ENGORGED.get()).toString() + "NU")));
                    screen.addModWidget(new ModWidget(columnBlockRelX + labelWidth + target_top, columnRelY - 1, 1, columnHeight + 2, colorTargetIndicator)).setToolTip(Component.m_130674_((String)("Target Cap: " + ((Double)Config.NUTRIENT_TARGET_HIGH.get()).toString() + "NU")));
                }
                columnDrawY -= nBlockHeight;
            }
        }
    }
}

