/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.lunchbox;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.gui.INutrientGUIScreen;
import com.dannyandson.nutritionalbalance.gui.ModWidget;
import com.dannyandson.nutritionalbalance.gui.NutrientGUIHelper;
import com.dannyandson.nutritionalbalance.lunchbox.LunchBoxItem;
import com.dannyandson.nutritionalbalance.lunchbox.LunchBoxMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class LunchBoxScreen
extends AbstractContainerScreen<LunchBoxMenu>
implements MenuAccess<LunchBoxMenu>,
INutrientGUIScreen {
    public static final ResourceLocation GUI = new ResourceLocation("nutritionalbalance", "textures/gui/lunchbox_gui.png");
    public static final ResourceLocation GUI_SLOT = new ResourceLocation("nutritionalbalance", "textures/gui/slot.png");
    private final LunchBoxMenu lunchBoxMenu;
    private final ModWidget[] widgets = new ModWidget[((Integer)Config.LUNCHBOX_SLOT_COUNT.get()).intValue()];

    public LunchBoxScreen(LunchBoxMenu lunchBoxMenu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)lunchBoxMenu, playerInventory, title);
        this.lunchBoxMenu = lunchBoxMenu;
        this.f_97726_ = 250;
        this.f_97727_ = 250;
        this.f_97731_ = this.f_97736_ + 156;
        this.f_97730_ = this.f_97735_ + 46;
        this.f_97729_ = this.f_97736_ + 111;
        this.f_97728_ = this.f_97735_ + 46;
    }

    protected void m_7856_() {
        super.m_7856_();
        NutrientGUIHelper.init(this, this.f_97726_, this.f_97727_ / 2, -this.f_97727_ / 4);
        for (int i = 0; i < (Integer)Config.LUNCHBOX_SLOT_COUNT.get(); ++i) {
            int finalI = i;
            this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 46 + i * 18, this.f_97736_ + 123, 18, 10, Component.m_130674_((String)" "), button -> this.toggleActive(finalI)));
            this.m_142416_((GuiEventListener)new ModWidget(this.f_97735_ + 46 + i * 18, this.f_97736_ + 133, 17, 17, -13158601));
            this.m_142416_((GuiEventListener)new ModWidget(this.f_97735_ + 47 + i * 18, this.f_97736_ + 134, 17, 17, -65794));
            this.m_142416_((GuiEventListener)new ModWidget(this.f_97735_ + 47 + i * 18, this.f_97736_ + 134, 16, 16, -7631989));
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.widgets[0] == null) {
            this.renderActiveOverlays();
        }
    }

    public void m_6574_(@NotNull Minecraft p_96575_, int p_96576_, int p_96577_) {
        super.m_6574_(p_96575_, p_96576_, p_96577_);
        this.renderActiveOverlays();
    }

    public void m_6305_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void toggleActive(int slot) {
        this.lunchBoxMenu.setActiveSlot(slot);
        this.renderActiveOverlays();
    }

    private void renderActiveOverlays() {
        for (int i = 0; i < (Integer)Config.LUNCHBOX_SLOT_COUNT.get(); ++i) {
            LunchBoxItem lunchBoxItem;
            if (this.widgets[i] != null) {
                this.m_169411_((GuiEventListener)this.widgets[i]);
            }
            int color = -1;
            String slotItem = ((Slot)this.lunchBoxMenu.f_38839_.get(i)).m_7993_().m_41778_();
            Item item = this.lunchBoxMenu.getLunchBoxItemStack().m_41720_();
            if (item instanceof LunchBoxItem && (lunchBoxItem = (LunchBoxItem)item).getActiveFoodItemStack(this.lunchBoxMenu.getLunchBoxItemStack()) != null && lunchBoxItem.getActiveFoodItemStack(this.lunchBoxMenu.getLunchBoxItemStack()).m_41778_().equals(slotItem)) {
                color = -16711936;
            }
            this.widgets[i] = new ModWidget(this.f_97735_ + 47 + i * 18, this.f_97736_ + 124, 16, 8, color);
            this.m_142416_((GuiEventListener)this.widgets[i]);
        }
    }

    @Override
    public int getWidth() {
        return this.f_96543_;
    }

    @Override
    public int getHeight() {
        return this.f_96544_;
    }

    @Override
    public ModWidget addModWidget(ModWidget modWidget) {
        return (ModWidget)this.m_142416_((GuiEventListener)modWidget);
    }
}

