/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.nutrients;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldNutrients {
    private static final List<Nutrient> nutrients = new ArrayList<Nutrient>();
    private static final Map<Item, List<Nutrient>> nutrientMap = new HashMap<Item, List<Nutrient>>();

    public static void register() {
        WorldNutrients.reset();
        for (TagKey tagKey : Registry.f_122827_.m_203613_().toList()) {
            ResourceLocation resourceLocation = tagKey.f_203868_();
            String namespace = resourceLocation.m_135827_();
            String path = resourceLocation.m_135815_();
            if (!namespace.equals("forge") || !path.startsWith("nutrients/")) continue;
            nutrients.add(new Nutrient(path.substring(10)));
        }
        if (nutrients.size() > 0 && WorldNutrients.getByName("proteins") == null) {
            nutrients.add(new Nutrient("proteins"));
        }
    }

    public static List<Nutrient> get() {
        if (nutrients.size() == 0) {
            WorldNutrients.register();
        }
        return nutrients;
    }

    public static Nutrient getByName(String name) {
        for (Nutrient nutrient : WorldNutrients.get()) {
            if (!nutrient.name.equals(name)) continue;
            return nutrient;
        }
        return null;
    }

    public static List<Nutrient> getNutrients(Item item, @Nullable Level world) {
        return WorldNutrients.getNutrients(item, world, 1);
    }

    private static List<Nutrient> getNutrients(Item item, @Nullable Level world, int iteration) {
        if (!nutrientMap.containsKey(item)) {
            Nutrient nutrient;
            ArrayList<Nutrient> nutrientList = new ArrayList<Nutrient>();
            for (TagKey tagKey : item.m_7968_().m_204131_().toList()) {
                ResourceLocation tag = tagKey.f_203868_();
                Nutrient nutrient2 = null;
                if (tag.m_135827_().equals("forge") && tag.m_135815_().startsWith("nutrients/")) {
                    nutrient2 = WorldNutrients.getByName(tag.m_135815_().substring(10));
                } else if (((List)Config.LIST_Fruits.get()).contains("#" + tag.m_135827_() + ":" + tag.m_135815_()) && !nutrientList.contains(WorldNutrients.getByName("fruits"))) {
                    nutrient2 = WorldNutrients.getByName("fruits");
                } else if (((List)Config.LIST_PROTEINS.get()).contains("#" + tag.m_135827_() + ":" + tag.m_135815_()) && !nutrientList.contains(WorldNutrients.getByName("proteins"))) {
                    nutrient2 = WorldNutrients.getByName("proteins");
                } else if (((List)Config.LIST_CARBS.get()).contains("#" + tag.m_135827_() + ":" + tag.m_135815_()) && !nutrientList.contains(WorldNutrients.getByName("carbs"))) {
                    nutrient2 = WorldNutrients.getByName("carbs");
                } else if (((List)Config.LIST_VEGETABLES.get()).contains("#" + tag.m_135827_() + ":" + tag.m_135815_()) && !nutrientList.contains(WorldNutrients.getByName("vegetables"))) {
                    nutrient2 = WorldNutrients.getByName("vegetables");
                } else if (((List)Config.LIST_SUGARS.get()).contains("#" + tag.m_135827_() + ":" + tag.m_135815_()) && !nutrientList.contains(WorldNutrients.getByName("sugars"))) {
                    nutrient2 = WorldNutrients.getByName("sugars");
                }
                if (nutrient2 == null || nutrientList.contains(nutrient2)) continue;
                nutrientList.add(nutrient2);
            }
            String itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item).m_135827_() + ":" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
            if (((List)Config.LIST_Fruits.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("fruits")) && (nutrient = WorldNutrients.getByName("fruits")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_PROTEINS.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("proteins")) && (nutrient = WorldNutrients.getByName("proteins")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_CARBS.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("carbs")) && (nutrient = WorldNutrients.getByName("carbs")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_VEGETABLES.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("vegetables")) && (nutrient = WorldNutrients.getByName("vegetables")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_SUGARS.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("sugars")) && (nutrient = WorldNutrients.getByName("sugars")) != null) {
                nutrientList.add(nutrient);
            }
            if (nutrientList.size() == 0 && iteration < 5) {
                if (item.m_41473_() != null && item.m_41473_().m_38746_()) {
                    Nutrient proteinNutrient = WorldNutrients.getByName("proteins");
                    if (proteinNutrient != null && !nutrientList.contains(proteinNutrient)) {
                        nutrientList.add(proteinNutrient);
                    }
                } else if (world != null) {
                    Collection recipes = world.m_7465_().m_44051_();
                    for (Recipe recipe : recipes) {
                        ItemStack recipeItemStack = recipe.m_8043_();
                        if (recipeItemStack == null || recipe.m_8043_().m_41720_() != item) continue;
                        NonNullList ingredients = recipe.m_7527_();
                        for (Ingredient ingredient : ingredients) {
                            ItemStack[] itemStacks = ingredient.m_43908_();
                            if (itemStacks.length <= 0) continue;
                            List<Nutrient> ingredientNutrients = WorldNutrients.getNutrients(itemStacks[0].m_41720_(), world, iteration + 1);
                            for (Nutrient ingredientNutrient : ingredientNutrients) {
                                if (nutrientList.contains(ingredientNutrient)) continue;
                                nutrientList.add(ingredientNutrient);
                            }
                        }
                    }
                }
            }
            nutrientMap.put(item, nutrientList);
        }
        return nutrientMap.get(item);
    }

    public static float getEffectiveFoodQuality(FoodProperties foodItem, int numberOfNutrients) {
        return WorldNutrients.getEffectiveFoodQuality(foodItem.m_38744_(), foodItem.m_38745_(), numberOfNutrients);
    }

    public static float getEffectiveFoodQuality(float healing, float saturation, int numberOfNutrients) {
        float saturation1 = healing * saturation * 2.0f;
        return Math.min(healing + saturation1, ((Double)Config.NUTRIENT_MAX_FOOD_VALUE.get()).floatValue() * (float)numberOfNutrients);
    }

    public static void reset() {
        nutrients.clear();
        nutrientMap.clear();
    }
}

