/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Locale;
import net.coderbot.iris.gl.GLDebug;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.shader.ShaderWorkarounds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlShader
extends GlResource {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final String name;

    public GlShader(ShaderType type, String name, String src) {
        super(GlShader.createShader(type, name, src));
        this.name = name;
    }

    private static int createShader(ShaderType type, String name, String src) {
        int result;
        int handle = GlStateManager.m_84447_((int)type.id);
        ShaderWorkarounds.safeShaderSource(handle, src);
        GlStateManager.m_84465_((int)handle);
        GLDebug.nameObject(33505, handle, name + "(" + type.name().toLowerCase(Locale.ROOT) + ")");
        String log = IrisRenderSystem.getShaderInfoLog(handle);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + name + ": " + log);
        }
        if ((result = GlStateManager.m_84449_((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed for " + name + ", see log for details");
        }
        return handle;
    }

    public String getName() {
        return this.name;
    }

    public int getHandle() {
        return this.getGlId();
    }

    @Override
    protected void destroyInternal() {
        GlStateManager.m_84421_((int)this.getGlId());
    }
}

