/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.gui.PlayerConfigScreen;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;

public class ClientboundPlayerConfigHelpPacket {
    private final String optionId;

    public ClientboundPlayerConfigHelpPacket(String optionId) {
        this.optionId = optionId;
    }

    public static class ClientHandler
    implements Consumer<ClientboundPlayerConfigHelpPacket> {
        @Override
        public void accept(ClientboundPlayerConfigHelpPacket t) {
            IPlayerConfigClientStorageManager playerConfigStorageManager = (IPlayerConfigClientStorageManager)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager();
            IPlayerConfigOptionSpecAPI<?> option = playerConfigStorageManager.getOptionForId(t.optionId);
            if (option != null) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)""));
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)PlayerConfigScreen.getUICommentForOption(option));
            }
        }
    }

    public static class Codec
    implements BiConsumer<ClientboundPlayerConfigHelpPacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ClientboundPlayerConfigHelpPacket> {
        @Override
        public ClientboundPlayerConfigHelpPacket apply(FriendlyByteBuf friendlyByteBuf) {
            try {
                if (friendlyByteBuf.readableBytes() > 10240) {
                    return null;
                }
                CompoundTag tag = friendlyByteBuf.m_130261_();
                if (tag == null) {
                    return null;
                }
                String optionId = tag.m_128461_("i");
                if (optionId.length() > 1000) {
                    OpenPartiesAndClaims.LOGGER.info("Received player config option id string is not allowed!");
                    return null;
                }
                return new ClientboundPlayerConfigHelpPacket(optionId);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(ClientboundPlayerConfigHelpPacket t, FriendlyByteBuf friendlyByteBuf) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("i", t.optionId);
            friendlyByteBuf.m_130079_(tag);
        }
    }
}

