/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.ClientPartyAllyInfo;
import xaero.pac.client.parties.party.IClientParty;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPartyAllyPacket
extends LazyPacket<LazyPacket.Encoder<ClientboundPartyAllyPacket>, ClientboundPartyAllyPacket> {
    public static final LazyPacket.Encoder<ClientboundPartyAllyPacket> ENCODER = new LazyPacket.Encoder();
    private final Action action;
    private final ClientPartyAllyInfo allyInfo;

    public ClientboundPartyAllyPacket(Action action, ClientPartyAllyInfo allyInfo) {
        this.action = action;
        this.allyInfo = allyInfo;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundPartyAllyPacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundPartyAllyPacket> encoder, FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("i", this.allyInfo.getAllyId());
        tag.m_128359_("n", this.allyInfo.getAllyName());
        tag.m_128359_("dn", this.allyInfo.getAllyDefaultName());
        tag.m_128359_("a", this.action.toString());
        u.m_130079_(tag);
    }

    public String toString() {
        return String.format("[%s, %s, %s]", new Object[]{this.action, this.allyInfo.getAllyName(), this.allyInfo.getAllyDefaultName()});
    }

    public static enum Action {
        ADD,
        REMOVE,
        UPDATE;

    }

    public static class ClientHandler
    implements Consumer<ClientboundPartyAllyPacket> {
        @Override
        public void accept(ClientboundPartyAllyPacket t) {
            IClientParty party = (IClientParty)((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).getParty();
            if (party == null) {
                return;
            }
            if (t.action == Action.ADD) {
                party.addAllyParty(t.allyInfo.getAllyId());
            } else {
                party.removeAllyParty(t.allyInfo.getAllyId());
            }
            if (t.action == Action.UPDATE) {
                party.addAllyParty(t.allyInfo.getAllyId());
            }
            if (t.action == Action.REMOVE) {
                ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).getAllyInfoStorage().remove(t.allyInfo.getAllyId());
            } else {
                ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).getAllyInfoStorage().add(t.allyInfo);
            }
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundPartyAllyPacket> {
        @Override
        public ClientboundPartyAllyPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 102400) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                UUID allyId = tag.m_128342_("i");
                String allyName = tag.m_128461_("n");
                if (allyName.length() > 512) {
                    return null;
                }
                String allyDefaultName = tag.m_128461_("dn");
                if (allyDefaultName.length() > 512) {
                    return null;
                }
                String actionString = tag.m_128461_("a");
                if (actionString.isEmpty() || actionString.length() > 128) {
                    return null;
                }
                Action action = Action.valueOf(actionString);
                return new ClientboundPartyAllyPacket(action, new ClientPartyAllyInfo(allyId, allyName, allyDefaultName));
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }
}

