/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyCommands;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class RankPartyCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<CommandSourceStack> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.ADMIN.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"member").requires(requirement)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"rank").requires(requirement)).then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82981_(Arrays.asList(PartyMemberRank.values()).stream().map(r -> r.toString()), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PartyCommands.getPartyMemberSuggestor()).executes(context -> {
            String targetUsername;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(playerId);
            IPartyPlayerInfo targetPlayerInfo = (IPartyPlayerInfo)playerParty.getMemberInfo(targetUsername = StringArgumentType.getString((CommandContext)context, (String)"name"));
            if (targetPlayerInfo == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_rank_not_member", targetUsername));
                return 0;
            }
            IPartyMember casterInfo = (IPartyMember)playerParty.getMemberInfo(playerId);
            boolean casterIsOwner = playerParty.getOwner() == casterInfo;
            IPartyMember targetMember = (IPartyMember)targetPlayerInfo;
            if (!casterIsOwner && targetMember.getRank().ordinal() >= casterInfo.getRank().ordinal() || targetMember == playerParty.getOwner()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_rank_not_lower_rank_player", new Object[0]));
                return 0;
            }
            String targetRankString = StringArgumentType.getString((CommandContext)context, (String)"rank");
            PartyMemberRank targetRank = PartyMemberRank.valueOf(targetRankString);
            if (!casterIsOwner && targetRank.ordinal() >= casterInfo.getRank().ordinal()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_rank_not_lower_rank", new Object[0]));
                return 0;
            }
            playerParty.setRank(targetMember, targetRank);
            UUID targetPlayerId = targetMember.getUUID();
            ServerPlayer rankedPlayer = server.m_6846_().m_11259_(targetPlayerId);
            if (rankedPlayer != null) {
                server.m_129892_().m_82095_(rankedPlayer);
            }
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (Component)Component.m_237110_((String)"gui.xaero_parties_rank_party_message", (Object[])new Object[]{Component.m_237113_((String)casterInfo.getUsername()).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN)), Component.m_237113_((String)targetPlayerInfo.getUsername()).m_130938_(s -> s.m_131140_(ChatFormatting.YELLOW)), Component.m_237113_((String)targetRank.toString()).m_130938_(s -> s.m_131140_(targetRank.getColor()))}));
            return 1;
        })))));
        dispatcher.register(command);
    }
}

