/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config;

import com.electronwill.nightconfig.core.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import xaero.pac.client.player.config.PlayerConfigClientStorage;
import xaero.pac.client.player.config.api.IPlayerConfigClientStorageAPI;
import xaero.pac.common.packet.config.ClientboundPlayerConfigDynamicOptionsPacket;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public class PlayerConfigOptionSpec<T extends Comparable<T>>
implements IPlayerConfigOptionSpecAPI<T> {
    public static final Component INHERITED_TEXT = Component.m_237115_((String)"gui.xaero_pac_config_option_sub_inherited");
    public static final Component ON_TEXT = Component.m_237115_((String)"gui.xaero_pac_ui_on");
    public static final Component OFF_TEXT = Component.m_237115_((String)"gui.xaero_pac_ui_off");
    protected final String id;
    protected final String shortenedId;
    private final List<String> path;
    protected final T defaultValue;
    private final BiFunction<PlayerConfig<?>, T, T> defaultReplacer;
    private final String comment;
    private final String translation;
    private final String[] translationArgs;
    private final String commentTranslation;
    private final String[] commentTranslationArgs;
    private final PlayerConfigOptionCategory category;
    protected final Class<T> type;
    private final Function<String, T> commandInputParser;
    private final Function<T, Component> commandOutputWriter;
    private final BiPredicate<PlayerConfig<?>, T> serverSideValidator;
    private final BiPredicate<PlayerConfigClientStorage, T> clientSideValidator;
    private final BiPredicate<IPlayerConfigAPI, T> serverSideValidatorAPI;
    private final BiPredicate<IPlayerConfigClientStorageAPI<?>, T> clientSideValidatorAPI;
    private final String tooltipPrefix;
    private final Predicate<PlayerConfigType> configTypeFilter;
    private final ClientboundPlayerConfigDynamicOptionsPacket.OptionType syncOptionType;

    protected PlayerConfigOptionSpec(Class<T> type, String id, String shortenedId, List<String> path, T defaultValue, BiFunction<PlayerConfig<?>, T, T> defaultReplacer, String comment, String translation, String[] translationArgs, String commentTranslation, String[] commentTranslationArgs, PlayerConfigOptionCategory category, Function<String, T> commandInputParser, Function<T, Component> commandOutputWriter, BiPredicate<PlayerConfig<?>, T> serverSideValidator, BiPredicate<PlayerConfigClientStorage, T> clientSideValidator, String tooltipPrefix, Predicate<PlayerConfigType> configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType syncOptionType) {
        this.type = type;
        this.id = id;
        this.shortenedId = shortenedId;
        this.path = path;
        this.defaultValue = defaultValue;
        this.defaultReplacer = defaultReplacer;
        this.comment = comment;
        this.translation = translation;
        this.translationArgs = translationArgs;
        this.commentTranslation = commentTranslation;
        this.commentTranslationArgs = commentTranslationArgs;
        this.category = category;
        this.commandInputParser = commandInputParser;
        this.commandOutputWriter = commandOutputWriter;
        this.serverSideValidator = serverSideValidator;
        this.clientSideValidator = clientSideValidator;
        this.serverSideValidatorAPI = (c, v) -> serverSideValidator.test((PlayerConfig)c, (PlayerConfig<?>)v);
        this.clientSideValidatorAPI = (c, v) -> clientSideValidator.test((PlayerConfigClientStorage)c, (PlayerConfigClientStorage)v);
        this.tooltipPrefix = tooltipPrefix;
        this.configTypeFilter = configTypeFilter;
        this.syncOptionType = syncOptionType;
    }

    protected ForgeConfigSpec.Builder buildForgeSpec(ForgeConfigSpec.Builder builder) {
        return builder.comment(this.comment).translation(this.translation);
    }

    public PlayerConfigOptionSpec<T> applyToForgeSpec(ForgeConfigSpec.Builder builder) {
        this.buildForgeSpec(builder).define(this.id, this.defaultValue);
        return this;
    }

    private Component applyValueQuotesIfNeeded(Object value, Component valueString) {
        Component result = valueString;
        if (value instanceof String) {
            result = Component.m_237113_((String)"\"");
            result.m_7360_().add(valueString);
            result.m_7360_().add(Component.m_237113_((String)"\""));
        }
        return result;
    }

    public Component getValueDisplayName(Object value) {
        if (value == null) {
            return INHERITED_TEXT;
        }
        return this.applyValueQuotesIfNeeded(value, this.getCommandOutputWriterCast().apply(value));
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getShortenedId() {
        return this.shortenedId;
    }

    @Override
    @Nonnull
    public List<String> getPath() {
        return this.path;
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getTranslation() {
        return this.translation;
    }

    @Override
    @Nonnull
    public String[] getTranslationArgs() {
        return this.translationArgs;
    }

    @Override
    @Nonnull
    public String getCommentTranslation() {
        return this.commentTranslation;
    }

    @Override
    @Nonnull
    public String[] getCommentTranslationArgs() {
        return this.commentTranslationArgs;
    }

    @Override
    @Nonnull
    public String getComment() {
        return this.comment;
    }

    @Override
    @Nonnull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Nonnull
    public BiPredicate<IPlayerConfigAPI, T> getServerSideValidator() {
        return this.serverSideValidatorAPI;
    }

    @Override
    @Nonnull
    public BiPredicate<IPlayerConfigClientStorageAPI<?>, T> getClientSideValidator() {
        return this.clientSideValidatorAPI;
    }

    public BiPredicate<PlayerConfig<?>, T> getServerSideValidatorInternal() {
        return this.serverSideValidator;
    }

    public BiPredicate<PlayerConfigClientStorage, T> getClientSideValidatorInternal() {
        return this.clientSideValidator;
    }

    @Override
    @Nullable
    public String getTooltipPrefix() {
        return this.tooltipPrefix;
    }

    public String toString() {
        return String.format("[%s, %s]", this.id, this.type);
    }

    @Override
    @Nonnull
    public Function<String, T> getCommandInputParser() {
        return this.commandInputParser;
    }

    @Override
    @Nonnull
    public Function<T, Component> getCommandOutputWriter() {
        return this.commandOutputWriter;
    }

    public Function<Object, Component> getCommandOutputWriterCast() {
        return this.commandOutputWriter;
    }

    @Override
    @Nonnull
    public Predicate<PlayerConfigType> getConfigTypeFilter() {
        return this.configTypeFilter;
    }

    public BiFunction<PlayerConfig<?>, T, T> getDefaultReplacer() {
        return this.defaultReplacer;
    }

    public ClientboundPlayerConfigDynamicOptionsPacket.OptionType getSyncOptionType() {
        return this.syncOptionType;
    }

    public PlayerConfigOptionCategory getCategory() {
        return this.category;
    }

    public static final class FinalBuilder<T extends Comparable<T>>
    extends Builder<T, FinalBuilder<T>> {
        protected FinalBuilder(Class<T> valueType) {
            super(valueType);
        }

        @Override
        protected PlayerConfigOptionSpec<T> buildInternally(List<String> path, String shortenedId, Function<String, T> commandInputParser) {
            return new PlayerConfigOptionSpec<Comparable>(this.type, this.id, shortenedId, path, this.defaultValue, this.defaultReplacer, this.comment, this.translation, this.translationArgs, this.commentTranslation, this.commentTranslationArgs, this.category, commandInputParser, this.commandOutputWriter, this.serverSideValidator, this.clientSideValidator, this.tooltipPrefix, this.configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType.DEFAULT);
        }

        public static <T extends Comparable<T>> FinalBuilder<T> begin(Class<T> valueType) {
            return (FinalBuilder)new FinalBuilder<T>(valueType).setDefault();
        }
    }

    public static abstract class Builder<T extends Comparable<T>, B extends Builder<T, B>> {
        protected final B self = this;
        protected final Class<T> type;
        protected String id;
        protected T defaultValue;
        protected BiFunction<PlayerConfig<?>, T, T> defaultReplacer;
        protected String comment;
        protected String translation;
        protected String[] translationArgs;
        protected String commentTranslation;
        protected String[] commentTranslationArgs;
        protected PlayerConfigOptionCategory category;
        protected BiPredicate<PlayerConfig<?>, T> serverSideValidator;
        protected BiPredicate<PlayerConfigClientStorage, T> clientSideValidator;
        private Predicate<T> valueValidator;
        protected String tooltipPrefix;
        protected Function<T, Component> commandOutputWriter;
        protected Function<String, T> commandInputReader;
        protected Predicate<PlayerConfigType> configTypeFilter;

        protected Builder(Class<T> valueType) {
            this.type = valueType;
        }

        public B setDefault() {
            this.setId(null);
            this.setDefaultValue(null);
            this.setDefaultReplacer(null);
            this.setComment(null);
            this.setTranslation(null, new String[0]);
            this.setCommentTranslation(null, new String[0]);
            this.setCategory(null);
            this.setValueValidator(null);
            this.setClientSideValidator(null);
            this.setServerSideValidator(null);
            this.setTooltipPrefix(null);
            this.setConfigTypeFilter(t -> true);
            this.setCommandOutputWriter(null);
            this.setCommandInputReader(null);
            return this.self;
        }

        public B setId(String id) {
            this.id = id;
            return this.self;
        }

        public B setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this.self;
        }

        public B setDefaultReplacer(BiFunction<PlayerConfig<?>, T, T> defaultReplacer) {
            this.defaultReplacer = defaultReplacer;
            return this.self;
        }

        public B setComment(String comment) {
            this.comment = comment;
            return this.self;
        }

        public B setTranslation(String translation, String ... translationArgs) {
            this.translation = translation;
            this.translationArgs = translationArgs;
            return this.self;
        }

        public B setCommentTranslation(String translation, String ... translationArgs) {
            this.commentTranslation = translation;
            this.commentTranslationArgs = translationArgs;
            return this.self;
        }

        public B setCategory(PlayerConfigOptionCategory category) {
            this.category = category;
            return this.self;
        }

        public B setValueValidator(Predicate<T> valueValidator) {
            this.valueValidator = valueValidator;
            return this.self;
        }

        public B setClientSideValidator(BiPredicate<PlayerConfigClientStorage, T> clientSideValidator) {
            this.clientSideValidator = clientSideValidator;
            return this.self;
        }

        public B setServerSideValidator(BiPredicate<PlayerConfig<?>, T> serverSideValidator) {
            this.serverSideValidator = serverSideValidator;
            return this.self;
        }

        public B setTooltipPrefix(String tooltipPrefix) {
            this.tooltipPrefix = tooltipPrefix;
            return this.self;
        }

        public B setCommandOutputWriter(Function<T, Component> commandOutputWriter) {
            this.commandOutputWriter = commandOutputWriter;
            return this.self;
        }

        public B setCommandInputReader(Function<String, T> commandInputReader) {
            this.commandInputReader = commandInputReader;
            return this.self;
        }

        public B setConfigTypeFilter(Predicate<PlayerConfigType> configTypeFilter) {
            this.configTypeFilter = configTypeFilter;
            return this.self;
        }

        private Function<String, T> getCommandInputParser() {
            Function<String, Comparable> commandInputParser = null;
            if (this.type == Boolean.class) {
                commandInputParser = s -> Boolean.valueOf(s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on"));
            } else if (this.type == Integer.class) {
                commandInputParser = s -> Integer.valueOf(Integer.parseInt(s));
            } else if (this.type == Double.class) {
                commandInputParser = s -> Double.valueOf(Double.parseDouble(s));
            } else if (this.type == Float.class) {
                commandInputParser = s -> Float.valueOf(Float.parseFloat(s));
            } else if (this.type == String.class) {
                commandInputParser = s -> s;
            }
            return commandInputParser;
        }

        protected Predicate<T> buildValueValidator() {
            if (this.valueValidator == null) {
                if (this.type == String.class) {
                    throw new IllegalStateException();
                }
                return v -> true;
            }
            return this.valueValidator;
        }

        public BiPredicate<PlayerConfig<?>, T> buildServerSideValidator() {
            if (this.serverSideValidator == null) {
                return (c, v) -> this.valueValidator.test((Comparable)v);
            }
            return this.serverSideValidator;
        }

        public BiPredicate<PlayerConfigClientStorage, T> buildClientSideValidator() {
            if (this.clientSideValidator == null) {
                return (c, v) -> this.valueValidator.test((Comparable)v);
            }
            return this.clientSideValidator;
        }

        public PlayerConfigOptionSpec<T> build(Map<String, PlayerConfigOptionSpec<?>> dest) {
            if (this.id == null || this.defaultValue == null || this.comment == null || this.configTypeFilter == null || this.category == null) {
                throw new IllegalStateException();
            }
            if (this.commandOutputWriter == null) {
                if (this.type == Boolean.class) {
                    this.setCommandOutputWriter(o -> (Boolean)o != false ? ON_TEXT : OFF_TEXT);
                } else {
                    this.setCommandOutputWriter(o -> Component.m_237113_((String)o.toString()));
                }
            }
            if (this.translation == null) {
                this.setTranslation("gui.xaero_pac_player_config_" + this.id, new String[0]);
            }
            if (this.commentTranslation == null) {
                this.setCommentTranslation("gui.xaero_pac_player_config_tooltip_" + this.id, new String[0]);
            }
            if (this.commandInputReader == null) {
                this.commandInputReader = this.getCommandInputParser();
            }
            if (this.commandInputReader == null) {
                throw new IllegalStateException();
            }
            this.valueValidator = this.buildValueValidator();
            this.serverSideValidator = this.buildServerSideValidator();
            this.clientSideValidator = this.buildClientSideValidator();
            PlayerConfigOptionSpec<T> spec = this.buildInternally(Collections.unmodifiableList(StringUtils.split((String)this.id, (char)'.')), this.id.substring("playerConfig.".length()), this.commandInputReader);
            if (dest != null) {
                dest.put(spec.getId(), spec);
            }
            return spec;
        }

        protected abstract PlayerConfigOptionSpec<T> buildInternally(List<String> var1, String var2, Function<String, T> var3);
    }
}

