/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.client.model.BeeNestHelmetModel;
import cy.jdkdigital.productivebees.client.model.CombModel;
import cy.jdkdigital.productivebees.client.render.entity.DyeBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.HoarderBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.RancherBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.model.HoarderBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumCrystalBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumElvisBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumFoliageBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumShellBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.RancherBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimyBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SmallBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ThiccBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.TinyBeeModel;
import cy.jdkdigital.productivebees.common.block.CombBlock;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.item.SpawnEgg;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="productivebees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEvents {
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        Item item;
        for (RegistryObject<Item> eggItem : ModItems.SPAWN_EGGS) {
            if (ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, eggItem, (String)"value") == null || !((item = (Item)eggItem.get()) instanceof SpawnEgg)) continue;
            event.register((stack, tintIndex) -> ((SpawnEgg)item).getColor(tintIndex, stack), new ItemLike[]{item});
        }
        for (RegistryObject registryItem : ModItems.ITEMS.getEntries()) {
            Block block;
            item = (Item)registryItem.get();
            if (item instanceof Honeycomb) {
                event.register(((Honeycomb)item)::getColor, new ItemLike[]{item});
                continue;
            }
            if (!(item instanceof BlockItem) || !((block = ((BlockItem)item).m_40614_()) instanceof CombBlock)) continue;
            event.register((stack, tintIndex) -> ((CombBlock)block).getColor(stack), new ItemLike[]{item});
        }
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return event.getBlockColors().m_92577_(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)ModBlocks.BUMBLE_BEE_NEST.get()});
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.m_92589_((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)lightReader, (BlockPos)pos) : -1, new Block[]{(Block)ModBlocks.SUGAR_CANE_NEST.get()});
        colors.m_92589_((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)lightReader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)ModBlocks.BUMBLE_BEE_NEST.get()});
        for (RegistryObject registryBlock : ModBlocks.BLOCKS.getEntries()) {
            Block block = (Block)registryBlock.get();
            if (!(block instanceof CombBlock)) continue;
            colors.m_92589_((blockState, lightReader, pos, tintIndex) -> ((CombBlock)block).getColor(lightReader, pos), new Block[]{block});
        }
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_MAIN_LAYER, ProductiveBeeModel::createBodyLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_HOARDER_LAYER, HoarderBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_RANCHER_LAYER, RancherBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_THICC_LAYER, ThiccBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_LAYER, MediumBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_CRYSTAL_LAYER, MediumCrystalBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_SHELL_LAYER, MediumShellBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_FOLIAGE_LAYER, MediumFoliageBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_ELVIS_LAYER, MediumElvisBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SLIM_LAYER, SlimBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SLIMY_LAYER, SlimyBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SMALL_LAYER, SmallBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SMALL_LAYER, SmallBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_TINY_LAYER, TinyBeeModel::createLayer);
        event.registerLayerDefinition(BeeNestHelmetModel.LAYER_LOCATION, BeeNestHelmetModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRendering(EntityRenderersEvent.RegisterRenderers event) {
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            EntityType bee = (EntityType)registryObject.get();
            String key = bee.m_20675_();
            if (key.contains("dye_bee")) {
                event.registerEntityRenderer(bee, DyeBeeRenderer::new);
                continue;
            }
            if (key.contains("rancher_bee") || key.contains("farmer_bee")) {
                event.registerEntityRenderer(bee, RancherBeeRenderer::new);
                continue;
            }
            if (key.contains("hoarder_bee")) {
                event.registerEntityRenderer(bee, HoarderBeeRenderer::new);
                continue;
            }
            event.registerEntityRenderer(bee, ProductiveBeeRenderer::new);
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            event.registerEntityRenderer((EntityType)registryObject.get(), ProductiveBeeRenderer::new);
        }
        event.registerEntityRenderer((EntityType)ModEntities.BEE_BOMB.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("comb", (IGeometryLoader)CombModel.Loader.INSTANCE);
    }
}

