/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.tasks.TasksRegistry;

public class KillNbtTask
extends KillTask {
    public CompoundTag nbt = new CompoundTag();
    public ItemStack item = ItemStack.f_41583_;
    public boolean checkItem;

    public KillNbtTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.KILLNBT;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128365_("nbt", (Tag)this.nbt);
        nbt.m_128379_("checkItem", this.checkItem);
        if (this.checkItem) {
            NBTUtils.write((CompoundTag)nbt, (String)"item", (ItemStack)this.item);
        }
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.nbt = nbt.m_128469_("nbt");
        this.checkItem = nbt.m_128471_("checkItem");
        if (this.checkItem) {
            this.item = NBTUtils.read((CompoundTag)nbt, (String)"item");
        }
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130079_(this.nbt);
        buffer.writeBoolean(this.checkItem);
        if (this.checkItem) {
            FTBQuestsNetHandler.writeItemType((FriendlyByteBuf)buffer, (ItemStack)this.item);
        }
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.nbt = buffer.m_130260_();
        this.checkItem = buffer.readBoolean();
        if (this.checkItem) {
            this.item = FTBQuestsNetHandler.readItemType((FriendlyByteBuf)buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ((NBTConfig)config.add("nbt", (ConfigValue)new NBTConfig(), (Object)this.nbt, v -> {
            this.nbt = v;
        }, (Object)new CompoundTag())).setNameKey("questsadditions.task.nbt");
        config.addBool("check_item", this.checkItem, v -> {
            this.checkItem = v;
        }, false).setNameKey("questsadditions.task.check_item");
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, true).setNameKey("ftbquests.task.ftbquests.item");
    }

    public void kill(TeamData teamData, LivingEntity e) {
        CompoundTag entitynbt;
        if (!teamData.isCompleted((QuestObject)this) && this.entity.equals((Object)Registries.getId((Object)e.m_6095_(), (ResourceKey)Registry.f_122903_)) && (!this.checkItem || ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)e.m_21232_().m_21205_())) && this.Compoundequals(this.nbt, entitynbt = e.m_20240_(new CompoundTag()))) {
            teamData.addProgress((Task)this, 1L);
        }
    }

    private boolean Compoundequals(CompoundTag nbt, CompoundTag entitynbt) {
        for (String key : nbt.m_128431_()) {
            Tag tag = nbt.m_128423_(key);
            if (tag.m_7060_() == 10) {
                if (entitynbt.m_128425_(key, 10)) {
                    CompoundTag compoundtag = entitynbt.m_128469_(key);
                    if (this.Compoundequals((CompoundTag)tag, compoundtag)) continue;
                    return false;
                }
                return false;
            }
            if (tag.m_7060_() == 9) {
                if (entitynbt.m_128425_(key, 9)) {
                    byte type = ((ListTag)tag).m_7264_();
                    ListTag listtag = entitynbt.m_128437_(key, (int)type);
                    if (this.Listequals((ListTag)tag, listtag)) continue;
                    return false;
                }
                return false;
            }
            if (tag.equals(entitynbt.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    private boolean Listequals(ListTag nbt, ListTag entitynbt) {
        if (entitynbt.size() < nbt.size()) {
            return false;
        }
        for (int i = 0; i < nbt.size(); ++i) {
            Tag tag = nbt.get(i);
            Tag entitytag = entitynbt.get(i);
            if (!(tag.m_7060_() == 10 && entitytag.m_7060_() == 10 ? !this.Compoundequals((CompoundTag)tag, (CompoundTag)entitytag) : (tag.m_7060_() == 9 && entitytag.m_7060_() == 9 ? !this.Listequals((ListTag)tag, (ListTag)entitytag) : !tag.equals(entitytag)))) continue;
            return false;
        }
        return true;
    }
}

