/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class MonumentPieces {
    private MonumentPieces() {
    }

    public static List<StructurePiece> createMonumentBuilding(RegistryAccess registryAccess, StructureTemplateManager StructureTemplateManager2, RandomSource random, int x, int y, int z, String monumentType) {
        Registry poolRegistry = registryAccess.m_175515_(Registry.f_122884_);
        ArrayList<StructurePiece> pieces = new ArrayList<StructurePiece>();
        MonumentBuilding mainBuilding = new MonumentBuilding((Registry<StructureTemplatePool>)poolRegistry, StructureTemplateManager2, random, monumentType);
        mainBuilding.addMainBody(pieces, (Registry<StructureTemplatePool>)poolRegistry, StructureTemplateManager2, random, Rotation.NONE, monumentType);
        pieces.addAll(mainBuilding.childPieces);
        pieces.forEach(piece -> piece.m_6324_(x, y, z));
        return pieces;
    }

    private static StructurePiece getJigsawPiece(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager structureTemplateManager, String poolPath, BlockPos blockPos, Rotation rotation, RandomSource random, String type) {
        StructurePoolElement poolEntry;
        ResourceLocation resourceLocation = new ResourceLocation(poolPath.toLowerCase(Locale.ROOT));
        StructureTemplatePool pool = (StructureTemplatePool)poolRegistry.m_7745_(resourceLocation);
        if (pool == null || pool.m_210590_() == 0) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {}  Will not generate monument piece at spot.", (Object)(resourceLocation + " - Monument type: " + type));
            poolEntry = (StructurePoolElement)StructurePoolElement.m_210541_().apply(StructureTemplatePool.Projection.RIGID);
        } else {
            poolEntry = pool.m_227355_(random);
        }
        return new PoolElementStructurePiece(structureTemplateManager, poolEntry, blockPos, poolEntry.m_210540_(), rotation, poolEntry.m_214015_(structureTemplateManager, blockPos, rotation));
    }

    private static BlockPos getRoomPosition(RoomGraph roomGraph, int specialOffset) {
        int index = roomGraph.index;
        int x = index % 5;
        int z = index / 5 % 5;
        int y = index / 25;
        return new BlockPos(x * 8, y * 4, -(z + specialOffset) * 8 + 1).m_7918_(9, 0, 35);
    }

    private static Rotation getOpeningRotationFull(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.DOWN, Direction.NORTH -> Rotation.NONE;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
        };
    }

    public static class MonumentBuilding
    extends MonumentPiece {
        private RoomGraph sourceRoom;
        private RoomGraph coreRoom;
        protected final List<StructurePiece> childPieces = Lists.newArrayList();

        public MonumentBuilding(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, RandomSource random, String type) {
            super(null);
            BlockPos pos;
            List<RoomGraph> graphList = this.generateRoomGraph(random);
            this.sourceRoom.claimed = true;
            this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/core", MonumentPieces.getRoomPosition(this.coreRoom, 2), Rotation.NONE, random, type));
            ArrayList fitterList = Lists.newArrayList();
            fitterList.add(new FitDoubleXYRoom());
            fitterList.add(new FitDoubleYZRoom());
            fitterList.add(new FitDoubleZRoom());
            fitterList.add(new FitDoubleXRoom());
            fitterList.add(new FitDoubleYRoom());
            fitterList.add(new FitSimpleTopRoom());
            fitterList.add(new FitSimplePillarRoom(random));
            fitterList.add(new FitSimpleRoom());
            block0: for (RoomGraph chosenRoomGraph : graphList) {
                if (chosenRoomGraph.claimed || chosenRoomGraph.isSpecial()) continue;
                for (MonumentRoomFitter fitter : fitterList) {
                    if (!fitter.fits(chosenRoomGraph)) continue;
                    this.childPieces.add(fitter.create(poolRegistry, StructureTemplateManager2, Rotation.NONE, chosenRoomGraph, random, type));
                    fitter.createOpenings(this.childPieces, poolRegistry, StructureTemplateManager2, Rotation.NONE, chosenRoomGraph, random, type);
                    continue block0;
                }
            }
            if (this.sourceRoom.hasOpening[Direction.WEST.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).m_7918_(0, 1, 3);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/entrance_wall", pos, Rotation.NONE, random, type));
            }
            if (this.sourceRoom.hasOpening[Direction.EAST.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).m_7918_(6, 1, 3);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/entrance_wall", pos, Rotation.NONE, random, type));
            }
            if (this.sourceRoom.hasOpening[Direction.NORTH.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).m_7918_(3, 1, 0);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_1", pos, Rotation.NONE, random, type));
            }
            if (this.sourceRoom.hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).m_7918_(2, 4, 2);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
        }

        public void addMainBody(List<StructurePiece> pieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, RandomSource random, Rotation rotation, String type) {
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/body/ne_corner", new BlockPos(29, 0, 0), rotation, random, type));
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/body/nw_corner", new BlockPos(0, 0, 0), rotation, random, type));
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/body/se_corner", new BlockPos(29, 0, 29), rotation, random, type));
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/body/sw_corner", new BlockPos(0, 0, 29), rotation, random, type));
        }

        /*
         * WARNING - void declaration
         */
        private List<RoomGraph> generateRoomGraph(RandomSource random) {
            RoomGraph[] roomGraph = new RoomGraph[75];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int l = MonumentBuilding.getRoomIndex(i, 0, j);
                    roomGraph[l] = new RoomGraph(l);
                }
            }
            for (int i2 = 0; i2 < 5; ++i2) {
                for (int l2 = 0; l2 < 4; ++l2) {
                    int j4 = MonumentBuilding.getRoomIndex(i2, 1, l2);
                    roomGraph[j4] = new RoomGraph(j4);
                }
            }
            for (int j2 = 1; j2 < 4; ++j2) {
                for (int i3 = 0; i3 < 2; ++i3) {
                    int k4 = MonumentBuilding.getRoomIndex(j2, 2, i3);
                    roomGraph[k4] = new RoomGraph(k4);
                }
            }
            this.sourceRoom = roomGraph[GRIDROOM_SOURCE_INDEX];
            for (int k2 = 0; k2 < 5; ++k2) {
                for (int j3 = 0; j3 < 5; ++j3) {
                    for (int i4 = 0; i4 < 3; ++i4) {
                        int l4 = MonumentBuilding.getRoomIndex(k2, i4, j3);
                        if (roomGraph[l4] == null) continue;
                        for (Direction direction : Direction.values()) {
                            int l1;
                            int i1 = k2 + direction.m_122429_();
                            int j1 = i4 + direction.m_122430_();
                            int k1 = j3 + direction.m_122431_();
                            if (i1 < 0 || i1 >= 5 || k1 < 0 || k1 >= 5 || j1 < 0 || j1 >= 3 || roomGraph[l1 = MonumentBuilding.getRoomIndex(i1, j1, k1)] == null) continue;
                            if (k1 == j3) {
                                roomGraph[l4].setConnection(direction, roomGraph[l1]);
                                continue;
                            }
                            roomGraph[l4].setConnection(direction.m_122424_(), roomGraph[l1]);
                        }
                    }
                }
            }
            RoomGraph roomGraph1 = new RoomGraph(1003);
            RoomGraph roomGraph2 = new RoomGraph(1001);
            RoomGraph roomGraph3 = new RoomGraph(1002);
            roomGraph[GRIDROOM_TOP_CONNECT_INDEX].setConnection(Direction.UP, roomGraph1);
            roomGraph[GRIDROOM_LEFTWING_CONNECT_INDEX].setConnection(Direction.SOUTH, roomGraph2);
            roomGraph[GRIDROOM_RIGHTWING_CONNECT_INDEX].setConnection(Direction.SOUTH, roomGraph3);
            roomGraph1.claimed = true;
            roomGraph2.claimed = true;
            roomGraph3.claimed = true;
            this.sourceRoom.isSource = true;
            this.coreRoom = roomGraph[MonumentBuilding.getRoomIndex(random.m_188503_(4), 0, 2)];
            this.coreRoom.claimed = true;
            this.coreRoom.connections[Direction.EAST.m_122411_()].claimed = true;
            this.coreRoom.connections[Direction.NORTH.m_122411_()].claimed = true;
            this.coreRoom.connections[Direction.EAST.m_122411_()].connections[Direction.NORTH.m_122411_()].claimed = true;
            this.coreRoom.connections[Direction.UP.m_122411_()].claimed = true;
            this.coreRoom.connections[Direction.EAST.m_122411_()].connections[Direction.UP.m_122411_()].claimed = true;
            this.coreRoom.connections[Direction.NORTH.m_122411_()].connections[Direction.UP.m_122411_()].claimed = true;
            this.coreRoom.connections[Direction.EAST.m_122411_()].connections[Direction.NORTH.m_122411_()].connections[Direction.UP.m_122411_()].claimed = true;
            ObjectArrayList list = new ObjectArrayList();
            for (RoomGraph roomGraph4 : roomGraph) {
                if (roomGraph4 == null) continue;
                roomGraph4.updateOpenings();
                list.add((Object)roomGraph4);
            }
            roomGraph1.updateOpenings();
            Util.m_214673_((ObjectArrayList)list, (RandomSource)random);
            boolean bl = true;
            for (RoomGraph selectedRoomGraph : list) {
                int n = 0;
                for (int k5 = 0; n < 2 && k5 < 5; ++k5) {
                    void var7_14;
                    int l5 = random.m_188503_(6);
                    if (!selectedRoomGraph.hasOpening[l5]) continue;
                    int i6 = Direction.m_122376_((int)l5).m_122424_().m_122411_();
                    selectedRoomGraph.hasOpening[l5] = false;
                    selectedRoomGraph.connections[l5].hasOpening[i6] = false;
                    if (selectedRoomGraph.findSource((int)var7_14++) && selectedRoomGraph.connections[l5].findSource((int)var7_14++)) {
                        ++n;
                        continue;
                    }
                    selectedRoomGraph.hasOpening[l5] = true;
                    selectedRoomGraph.connections[l5].hasOpening[i6] = true;
                }
            }
            list.add((Object)roomGraph1);
            list.add((Object)roomGraph2);
            list.add((Object)roomGraph3);
            return list;
        }
    }

    static class RoomGraph {
        final int index;
        final RoomGraph[] connections = new RoomGraph[6];
        final boolean[] hasOpening = new boolean[6];
        boolean claimed;
        boolean isSource;
        private int scanIndex;

        public RoomGraph(int index) {
            this.index = index;
        }

        public void setConnection(Direction direction, RoomGraph roomGraph) {
            this.connections[direction.m_122411_()] = roomGraph;
            roomGraph.connections[direction.m_122424_().m_122411_()] = this;
        }

        public void updateOpenings() {
            for (int i = 0; i < 6; ++i) {
                this.hasOpening[i] = this.connections[i] != null;
            }
        }

        public boolean findSource(int index) {
            if (this.isSource) {
                return true;
            }
            this.scanIndex = index;
            for (int i = 0; i < 6; ++i) {
                if (this.connections[i] == null || !this.hasOpening[i] || this.connections[i].scanIndex == index || !this.connections[i].findSource(index)) continue;
                return true;
            }
            return false;
        }

        public boolean isSpecial() {
            return this.index >= 75;
        }
    }

    protected static abstract class MonumentPiece {
        protected static final int GRIDROOM_SOURCE_INDEX = MonumentPiece.getRoomIndex(2, 0, 0);
        protected static final int GRIDROOM_TOP_CONNECT_INDEX = MonumentPiece.getRoomIndex(2, 2, 0);
        protected static final int GRIDROOM_LEFTWING_CONNECT_INDEX = MonumentPiece.getRoomIndex(0, 1, 0);
        protected static final int GRIDROOM_RIGHTWING_CONNECT_INDEX = MonumentPiece.getRoomIndex(4, 1, 0);
        protected RoomGraph roomGraph;

        protected static int getRoomIndex(int x, int y, int z) {
            return y * 25 + z * 5 + x;
        }

        protected MonumentPiece(RoomGraph roomGraph) {
            this.roomGraph = roomGraph;
        }
    }

    static class FitSimpleTopRoom
    implements MonumentRoomFitter {
        FitSimpleTopRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return !roomGraph.hasOpening[Direction.WEST.m_122411_()] && !roomGraph.hasOpening[Direction.EAST.m_122411_()] && !roomGraph.hasOpening[Direction.NORTH.m_122411_()] && !roomGraph.hasOpening[Direction.SOUTH.m_122411_()] && !roomGraph.hasOpening[Direction.UP.m_122411_()];
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            roomGraph.claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/simple_top", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
        }
    }

    static class FitSimplePillarRoom
    implements MonumentRoomFitter {
        private final RandomSource random;

        FitSimplePillarRoom(RandomSource random) {
            this.random = random;
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return this.random.m_188499_() && !roomGraph.hasOpening[Direction.DOWN.m_122411_()] && !roomGraph.hasOpening[Direction.UP.m_122411_()];
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            roomGraph.claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/simple_pillar", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!roomGraph.hasOpening[direction.m_122411_()]) continue;
                Rotation rotation = MonumentPieces.getOpeningRotationFull(direction);
                BlockPos pos = MonumentPieces.getRoomPosition(roomGraph, 1).m_7918_(3, 1, 3).m_5484_(direction, 3);
                if (rotation == Rotation.CLOCKWISE_90) {
                    pos = pos.m_7918_(1, 0, 0);
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    pos = pos.m_7918_(1, 0, 1);
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                    pos = pos.m_7918_(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_1", pos, rotation, random, type));
            }
        }
    }

    static class FitSimpleRoom
    implements MonumentRoomFitter {
        FitSimpleRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return true;
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            roomGraph.claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/simple", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!roomGraph.hasOpening[direction.m_122411_()]) continue;
                Rotation rotation = MonumentPieces.getOpeningRotationFull(direction);
                BlockPos pos = MonumentPieces.getRoomPosition(roomGraph, 1).m_7918_(3, 1, 3).m_5484_(direction, 3);
                if (rotation == Rotation.CLOCKWISE_90) {
                    pos = pos.m_7918_(1, 0, 0);
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    pos = pos.m_7918_(1, 0, 1);
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                    pos = pos.m_7918_(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_1", pos, rotation, random, type));
            }
            if (roomGraph.hasOpening[Direction.UP.m_122411_()]) {
                BlockPos pos = MonumentPieces.getRoomPosition(roomGraph, 1).m_7918_(2, 4, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
        }
    }

    static class FitDoubleZRoom
    implements MonumentRoomFitter {
        FitDoubleZRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return roomGraph.hasOpening[Direction.NORTH.m_122411_()] && !roomGraph.connections[Direction.NORTH.m_122411_()].claimed;
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            RoomGraph roomGraph1 = roomGraph;
            if (!roomGraph.hasOpening[Direction.NORTH.m_122411_()] || roomGraph.connections[Direction.NORTH.m_122411_()].claimed) {
                roomGraph1 = roomGraph.connections[Direction.SOUTH.m_122411_()];
            }
            roomGraph1.claimed = true;
            roomGraph1.connections[Direction.NORTH.m_122411_()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/double_z", MonumentPieces.getRoomPosition(roomGraph, 2), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
            BlockPos pos;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos pos2;
                Rotation rotation;
                if (direction != Direction.NORTH && roomGraph.hasOpening[direction.m_122411_()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(4, 1, 12).m_5484_(direction, 4);
                    if (rotation == Rotation.CLOCKWISE_90) {
                        pos2 = pos2.m_7918_(-1, 0, -1);
                    } else if (rotation == Rotation.CLOCKWISE_180) {
                        pos2 = pos2.m_7918_(0, 0, -1);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
                }
                if (direction == Direction.SOUTH || !roomGraph.connections[Direction.NORTH.m_122411_()].hasOpening[direction.m_122411_()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(3, 1, 4).m_5484_(direction, 4);
                if (rotation == Rotation.CLOCKWISE_90) {
                    pos2 = pos2.m_7918_(0, 0, -1);
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    pos2 = pos2.m_7918_(1, 0, -1);
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                    pos2 = pos2.m_7918_(1, 0, 0);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
            }
            if (roomGraph.hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(2, 4, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
            if (roomGraph.connections[Direction.NORTH.m_122411_()].hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(2, 4, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
        }
    }

    static class FitDoubleYZRoom
    implements MonumentRoomFitter {
        FitDoubleYZRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            if (roomGraph.hasOpening[Direction.NORTH.m_122411_()] && !roomGraph.connections[Direction.NORTH.m_122411_()].claimed && roomGraph.hasOpening[Direction.UP.m_122411_()] && !roomGraph.connections[Direction.UP.m_122411_()].claimed) {
                RoomGraph monumentPieces$roomdefinition = roomGraph.connections[Direction.NORTH.m_122411_()];
                return monumentPieces$roomdefinition.hasOpening[Direction.UP.m_122411_()] && !monumentPieces$roomdefinition.connections[Direction.UP.m_122411_()].claimed;
            }
            return false;
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            roomGraph.claimed = true;
            roomGraph.connections[Direction.NORTH.m_122411_()].claimed = true;
            roomGraph.connections[Direction.UP.m_122411_()].claimed = true;
            roomGraph.connections[Direction.NORTH.m_122411_()].connections[Direction.UP.m_122411_()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/double_yz", MonumentPieces.getRoomPosition(roomGraph, 2), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
            BlockPos pos;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos pos2;
                Rotation rotation;
                if (direction != Direction.NORTH) {
                    if (roomGraph.hasOpening[direction.m_122411_()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(4, 1, 12).m_5484_(direction, 4);
                        if (rotation == Rotation.CLOCKWISE_90) {
                            pos2 = pos2.m_7918_(-1, 0, -1);
                        } else if (rotation == Rotation.CLOCKWISE_180) {
                            pos2 = pos2.m_7918_(0, 0, -1);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
                    }
                    if (roomGraph.connections[Direction.UP.m_122411_()].hasOpening[direction.m_122411_()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(4, 1, 11).m_5484_(direction, 5);
                        if (rotation == Rotation.CLOCKWISE_90) {
                            pos2 = pos2.m_7918_(-2, 0, -1);
                        } else if (rotation == Rotation.CLOCKWISE_180) {
                            pos2 = pos2.m_7918_(1, 0, -1);
                        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                            pos2 = pos2.m_7918_(1, 0, 2);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_shelf", pos2, rotation, random, type));
                    }
                }
                if (direction == Direction.SOUTH) continue;
                if (roomGraph.connections[Direction.NORTH.m_122411_()].hasOpening[direction.m_122411_()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(3, 1, 4).m_5484_(direction, 4);
                    if (rotation == Rotation.CLOCKWISE_90) {
                        pos2 = pos2.m_7918_(0, 0, -1);
                    } else if (rotation == Rotation.CLOCKWISE_180) {
                        pos2 = pos2.m_7918_(1, 0, -1);
                    } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                        pos2 = pos2.m_7918_(1, 0, 0);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
                }
                if (!roomGraph.connections[Direction.UP.m_122411_()].connections[Direction.NORTH.m_122411_()].hasOpening[direction.m_122411_()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(2, 1, 5).m_5484_(direction, 5);
                if (rotation == Rotation.CLOCKWISE_90) {
                    pos2 = pos2.m_7918_(0, 0, -3);
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    pos2 = pos2.m_7918_(2, 0, -2);
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                    pos2 = pos2.m_7918_(3, 0, 0);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_shelf", pos2, rotation, random, type));
            }
            if (roomGraph.connections[Direction.UP.m_122411_()].hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(2, 8, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
            if (roomGraph.connections[Direction.UP.m_122411_()].connections[Direction.NORTH.m_122411_()].hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(2, 8, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
        }
    }

    static class FitDoubleYRoom
    implements MonumentRoomFitter {
        FitDoubleYRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return roomGraph.hasOpening[Direction.UP.m_122411_()] && !roomGraph.connections[Direction.UP.m_122411_()].claimed;
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            roomGraph.claimed = true;
            roomGraph.connections[Direction.UP.m_122411_()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/double_y", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos pos;
                Rotation rotation;
                if (roomGraph.hasOpening[direction.m_122411_()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos = MonumentPieces.getRoomPosition(roomGraph, 1).m_7918_(3, 1, 3).m_5484_(direction, 4);
                    pos = rotation == Rotation.CLOCKWISE_90 ? pos.m_7918_(0, 0, -2) : (rotation == Rotation.CLOCKWISE_180 ? pos.m_7918_(3, 0, 0) : (rotation == Rotation.COUNTERCLOCKWISE_90 ? pos.m_7918_(1, 0, 3) : pos.m_7918_(-2, 0, 1)));
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/arch", pos, rotation, random, type));
                }
                if (!roomGraph.connections[Direction.UP.m_122411_()].hasOpening[direction.m_122411_()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos = MonumentPieces.getRoomPosition(roomGraph, 1).m_7918_(3, 5, 3).m_5484_(direction, 4);
                pos = rotation == Rotation.CLOCKWISE_90 ? pos.m_7918_(0, 0, -2) : (rotation == Rotation.CLOCKWISE_180 ? pos.m_7918_(3, 0, 0) : (rotation == Rotation.COUNTERCLOCKWISE_90 ? pos.m_7918_(1, 0, 3) : pos.m_7918_(-2, 0, 1)));
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/arch", pos, rotation, random, type));
            }
            if (roomGraph.connections[Direction.UP.ordinal()].hasOpening[Direction.UP.m_122411_()]) {
                BlockPos pos = MonumentPieces.getRoomPosition(roomGraph, 1).m_7918_(2, 8, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
        }
    }

    static class FitDoubleXYRoom
    implements MonumentRoomFitter {
        FitDoubleXYRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            if (roomGraph.hasOpening[Direction.EAST.m_122411_()] && !roomGraph.connections[Direction.EAST.m_122411_()].claimed && roomGraph.hasOpening[Direction.UP.m_122411_()] && !roomGraph.connections[Direction.UP.m_122411_()].claimed) {
                RoomGraph monumentPieces$roomdefinition = roomGraph.connections[Direction.EAST.m_122411_()];
                return monumentPieces$roomdefinition.hasOpening[Direction.UP.m_122411_()] && !monumentPieces$roomdefinition.connections[Direction.UP.m_122411_()].claimed;
            }
            return false;
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            roomGraph.claimed = true;
            roomGraph.connections[Direction.EAST.m_122411_()].claimed = true;
            roomGraph.connections[Direction.UP.m_122411_()].claimed = true;
            roomGraph.connections[Direction.EAST.m_122411_()].connections[Direction.UP.m_122411_()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/double_xy", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
            BlockPos pos;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos pos2;
                Rotation rotation;
                if (direction != Direction.EAST) {
                    if (roomGraph.hasOpening[direction.m_122411_()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(3, 1, 11).m_5484_(direction, 4);
                        if (rotation == Rotation.CLOCKWISE_180) {
                            pos2 = pos2.m_7918_(1, 0, 0);
                        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                            pos2 = pos2.m_7918_(1, 0, 1);
                        } else if (rotation == Rotation.NONE) {
                            pos2 = pos2.m_7918_(0, 0, 1);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
                    }
                    if (roomGraph.connections[Direction.UP.m_122411_()].hasOpening[direction.m_122411_()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(3, 5, 11).m_5484_(direction, 4);
                        if (rotation == Rotation.CLOCKWISE_180) {
                            pos2 = pos2.m_7918_(1, 0, 0);
                        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                            pos2 = pos2.m_7918_(1, 0, 1);
                        } else if (rotation == Rotation.NONE) {
                            pos2 = pos2.m_7918_(0, 0, 1);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
                    }
                }
                if (direction == Direction.WEST) continue;
                if (roomGraph.connections[Direction.EAST.m_122411_()].hasOpening[direction.m_122411_()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(11, 1, 11).m_5484_(direction, 4);
                    if (rotation == Rotation.CLOCKWISE_90) {
                        pos2 = pos2.m_7918_(0, 0, 0);
                    } else if (rotation == Rotation.CLOCKWISE_180) {
                        pos2 = pos2.m_7918_(1, 0, 0);
                    } else if (rotation == Rotation.NONE) {
                        pos2 = pos2.m_7918_(0, 0, 1);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
                }
                if (!roomGraph.connections[Direction.UP.m_122411_()].connections[Direction.EAST.m_122411_()].hasOpening[direction.m_122411_()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(11, 5, 11).m_5484_(direction, 4);
                if (rotation == Rotation.CLOCKWISE_90) {
                    pos2 = pos2.m_7918_(0, 0, 0);
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    pos2 = pos2.m_7918_(1, 0, 0);
                } else if (rotation == Rotation.NONE) {
                    pos2 = pos2.m_7918_(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
            }
            if (roomGraph.connections[Direction.UP.m_122411_()].hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(2, 8, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
            if (roomGraph.connections[Direction.UP.m_122411_()].connections[Direction.EAST.m_122411_()].hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(10, 8, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
        }
    }

    static class FitDoubleXRoom
    implements MonumentRoomFitter {
        FitDoubleXRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return roomGraph.hasOpening[Direction.EAST.m_122411_()] && !roomGraph.connections[Direction.EAST.m_122411_()].claimed;
        }

        @Override
        public StructurePiece create(Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation rotation, RoomGraph roomGraph, RandomSource random, String type) {
            roomGraph.claimed = true;
            roomGraph.connections[Direction.EAST.m_122411_()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/rooms/double_x", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type);
        }

        @Override
        public void createOpenings(List<StructurePiece> childPieces, Registry<StructureTemplatePool> poolRegistry, StructureTemplateManager StructureTemplateManager2, Rotation none, RoomGraph roomGraph, RandomSource random, String type) {
            BlockPos pos;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos pos2;
                Rotation rotation;
                if (direction != Direction.EAST && roomGraph.hasOpening[direction.m_122411_()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(3, 1, 11).m_5484_(direction, 4);
                    if (rotation == Rotation.CLOCKWISE_180) {
                        pos2 = pos2.m_7918_(1, 0, 0);
                    } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                        pos2 = pos2.m_7918_(1, 0, 1);
                    } else if (rotation == Rotation.NONE) {
                        pos2 = pos2.m_7918_(0, 0, 1);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
                }
                if (direction == Direction.WEST || !roomGraph.connections[Direction.EAST.m_122411_()].hasOpening[direction.m_122411_()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(11, 1, 11).m_5484_(direction, 4);
                if (rotation == Rotation.CLOCKWISE_90) {
                    pos2 = pos2.m_7918_(0, 0, 0);
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    pos2 = pos2.m_7918_(1, 0, 0);
                } else if (rotation == Rotation.NONE) {
                    pos2 = pos2.m_7918_(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type));
            }
            if (roomGraph.hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(2, 4, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
            if (roomGraph.connections[Direction.EAST.m_122411_()].hasOpening[Direction.UP.m_122411_()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).m_7918_(10, 4, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager2, "repurposed_structures:monuments/" + type + "/openings/floor", pos, Rotation.NONE, random, type));
            }
        }
    }

    static interface MonumentRoomFitter {
        public boolean fits(RoomGraph var1);

        public StructurePiece create(Registry<StructureTemplatePool> var1, StructureTemplateManager var2, Rotation var3, RoomGraph var4, RandomSource var5, String var6);

        public void createOpenings(List<StructurePiece> var1, Registry<StructureTemplatePool> var2, StructureTemplateManager var3, Rotation var4, RoomGraph var5, RandomSource var6, String var7);
    }
}

