/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.platform.common.worldgen.forge;

import com.github.teamfusion.platform.common.worldgen.BiomeContext;
import com.github.teamfusion.platform.common.worldgen.BiomeManager;
import com.github.teamfusion.platform.common.worldgen.BiomeWriter;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeManagerImpl {
    @Nullable
    private static Codec<PlatformBiomeModifier> codec = null;

    public static void setup() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            event.register(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, entry -> {
                codec = Codec.unit((Object)PlatformBiomeModifier.INSTANCE);
                entry.register(new ResourceLocation("rottencreatures", "biome_modifier_codec"), (Object)codec);
            });
            event.register(ForgeRegistries.Keys.BIOME_MODIFIERS, entry -> entry.register(new ResourceLocation("rottencreatures", "biome_modifier"), (Object)PlatformBiomeModifier.INSTANCE));
        });
    }

    static class PlatformBiomeModifier
    implements BiomeModifier {
        private static final PlatformBiomeModifier INSTANCE = new PlatformBiomeModifier();

        PlatformBiomeModifier() {
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                BiomeManager.INSTANCE.register(new ForgeBiomeWriter(biome, builder));
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return codec != null ? codec : Codec.unit((Object)INSTANCE);
        }
    }

    static class ForgeBiomeWriter
    extends BiomeWriter {
        private final Holder<Biome> biome;
        private final ModifiableBiomeInfo.BiomeInfo.Builder builder;

        ForgeBiomeWriter(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            this.biome = biome;
            this.builder = builder;
        }

        @Override
        public ResourceLocation name() {
            return ((ResourceKey)this.biome.m_203543_().get()).m_135782_();
        }

        @Override
        public BiomeContext context() {
            return new BiomeContext(){

                @Override
                public boolean is(TagKey<Biome> tag) {
                    return biome.m_203656_(tag);
                }

                @Override
                public boolean is(ResourceKey<Biome> biome) {
                    return biome.m_203565_(biome);
                }
            };
        }

        @Override
        public void addFeature(GenerationStep.Decoration step, Holder<PlacedFeature> feature) {
            this.builder.getGenerationSettings().m_204201_(step, feature);
        }

        @Override
        public void addSpawn(MobCategory category, EntityType<?> type, int weight, int minGroup, int maxGroup) {
            this.builder.getMobSpawnSettings().m_48376_(category, new MobSpawnSettings.SpawnerData(type, weight, minGroup, maxGroup));
        }
    }
}

