/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.model;

import com.github.teamfusion.rottencreatures.common.entities.Scarab;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ScarabModel<T extends Scarab>
extends HierarchicalModel<T> {
    protected final ModelPart root;
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart rightMiddleLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart leftMiddleLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightElytra;
    protected final ModelPart leftElytra;
    protected final ModelPart rightWing;
    protected final ModelPart leftWing;

    public ScarabModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightFrontLeg = this.body.m_171324_("right_front_leg");
        this.leftFrontLeg = this.body.m_171324_("left_front_leg");
        this.rightMiddleLeg = this.body.m_171324_("right_middle_leg");
        this.leftMiddleLeg = this.body.m_171324_("left_middle_leg");
        this.rightHindLeg = this.body.m_171324_("right_hind_leg");
        this.leftHindLeg = this.body.m_171324_("left_hind_leg");
        this.rightElytra = this.body.m_171324_("right_elytra");
        this.leftElytra = this.body.m_171324_("left_elytra");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -4.0f, -2.0f, 7.0f, 4.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-2.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(17, 26).m_171481_(-3.5f, 0.5f, -6.0f, 7.0f, 0.0f, 4.0f).m_171514_(17, 20).m_171481_(-2.5f, -1.0f, -2.0f, 5.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-2.0f));
        body.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(8, 27).m_171481_(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.m_171419_((float)3.5f, (float)0.0f, (float)-0.5f));
        body.m_171599_("left_middle_leg", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171481_(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.m_171419_((float)3.5f, (float)0.0f, (float)2.5f));
        body.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(8, 21).m_171481_(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.m_171419_((float)3.5f, (float)0.0f, (float)5.5f));
        body.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(3, 27).m_171481_(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)-0.5f));
        body.m_171599_("right_middle_leg", CubeListBuilder.m_171558_().m_171514_(3, 24).m_171481_(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)2.5f));
        body.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(3, 21).m_171481_(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)5.5f));
        body.m_171599_("right_elytra", CubeListBuilder.m_171558_().m_171514_(38, 51).m_171488_(-4.0f, -4.0f, 0.0f, 4.0f, 4.0f, 9.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        body.m_171599_("left_elytra", CubeListBuilder.m_171558_().m_171514_(38, 38).m_171488_(-0.0f, -4.0f, 0.0f, 4.0f, 4.0f, 9.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(-5, 52).m_171481_(-5.0f, 0.0f, 0.0f, 5.0f, 0.0f, 9.0f), PartPose.m_171419_((float)3.0f, (float)-4.0f, (float)-2.0f));
        body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(15, 52).m_171481_(0.0f, 0.0f, 0.0f, 5.0f, 0.0f, 9.0f), PartPose.m_171419_((float)-3.0f, (float)-4.0f, (float)-2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        float degree = 0.52f;
        this.rightFrontLeg.f_104204_ = Mth.m_14089_((float)(limbAngle * 5.0f + (float)Math.PI)) * 3.0f * limbDistance;
        this.rightFrontLeg.f_104203_ = 0.0f;
        this.rightFrontLeg.f_104205_ = -degree;
        this.rightMiddleLeg.f_104204_ = -Mth.m_14089_((float)(limbAngle * 5.0f + (float)Math.PI)) * 3.0f * limbDistance;
        this.rightMiddleLeg.f_104203_ = 0.0f;
        this.rightMiddleLeg.f_104205_ = -degree;
        this.rightHindLeg.f_104204_ = Mth.m_14089_((float)(limbAngle * 5.0f + (float)Math.PI)) * 3.0f * limbDistance;
        this.rightHindLeg.f_104203_ = 0.0f;
        this.rightHindLeg.f_104205_ = -degree;
        this.leftFrontLeg.f_104204_ = Mth.m_14089_((float)(limbAngle * 5.0f)) * 3.0f * limbDistance;
        this.leftFrontLeg.f_104203_ = 0.0f;
        this.leftFrontLeg.f_104205_ = degree;
        this.leftMiddleLeg.f_104204_ = -Mth.m_14089_((float)(limbAngle * 5.0f)) * 3.0f * limbDistance;
        this.leftMiddleLeg.f_104203_ = 0.0f;
        this.leftMiddleLeg.f_104205_ = degree;
        this.leftHindLeg.f_104204_ = Mth.m_14089_((float)(limbAngle * 5.0f)) * 3.0f * limbDistance;
        this.leftHindLeg.f_104203_ = 0.0f;
        this.leftHindLeg.f_104205_ = degree;
    }
}

