/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.renderer.entity;

import com.github.teamfusion.rottencreatures.client.model.ImmortalModel;
import com.github.teamfusion.rottencreatures.client.model.LayerBuilder;
import com.github.teamfusion.rottencreatures.client.renderer.entity.layers.DashAttackLayer;
import com.github.teamfusion.rottencreatures.client.renderer.entity.layers.ImmortalOverlayLayer;
import com.github.teamfusion.rottencreatures.client.renderer.entity.layers.ImpaledLayer;
import com.github.teamfusion.rottencreatures.common.entities.Immortal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class ImmortalRenderer<T extends Immortal>
extends HumanoidMobRenderer<T, ImmortalModel<T>> {
    public static final LayerBuilder LAYER = LayerBuilder.of("immortal");

    public ImmortalRenderer(EntityRendererProvider.Context context) {
        super(context, new ImmortalModel(context.m_174023_(LAYER.getMain())), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(LAYER.getInner())), new HumanoidModel(context.m_174023_(LAYER.getOuter()))));
        this.m_115326_(new ImpaledLayer(this, context.m_174027_()));
        this.m_115326_(new DashAttackLayer(this, context.m_174027_()));
        this.m_115326_(new ImmortalOverlayLayer(this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(Immortal mob) {
        return new ResourceLocation("rottencreatures", "textures/entity/immortal/immortal.png");
    }

    protected void setupRotations(T immortal, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta) {
        super.m_7523_(immortal, matrices, animationProgress, bodyYaw, tickDelta);
        if (!((double)((Immortal)((Object)immortal)).f_20924_ < 0.01)) {
            float timestamp = ((Immortal)((Object)immortal)).f_20925_ - ((Immortal)((Object)immortal)).f_20924_ * (1.0f - tickDelta) + 6.0f;
            float degreeModifier = (Math.abs(timestamp % 13.0f - 6.5f) - 3.25f) / 3.25f;
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(6.5f * degreeModifier));
        }
    }
}

