/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.renderer.entity;

import com.github.teamfusion.rottencreatures.client.model.LayerBuilder;
import com.github.teamfusion.rottencreatures.client.renderer.entity.layers.ZombieLackeyOuterLayer;
import com.github.teamfusion.rottencreatures.common.entities.ZombieLackey;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ZombieLackeyRenderer
extends AbstractZombieRenderer<ZombieLackey, DrownedModel<ZombieLackey>> {
    public static final LayerBuilder LAYER = LayerBuilder.of("zombie_lackey");
    public static final ModelLayerLocation OUTER_LAYER = LAYER.create("outer_layer");

    public ZombieLackeyRenderer(EntityRendererProvider.Context context) {
        super(context, (ZombieModel)new DrownedModel(context.m_174023_(LAYER.getMain())), (ZombieModel)new DrownedModel(context.m_174023_(LAYER.getInner())), (ZombieModel)new DrownedModel(context.m_174023_(LAYER.getOuter())));
        this.m_115326_(new ZombieLackeyOuterLayer(this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(ZombieLackey lackey) {
        return new ResourceLocation("rottencreatures", "textures/entity/zombie_lackey.png");
    }

    protected void setupRotations(ZombieLackey lackey, PoseStack matrices, float animationProgress, float bodyYaw, float ticksDelta) {
        super.m_7523_((LivingEntity)lackey, matrices, animationProgress, bodyYaw, ticksDelta);
        float swimAmount = lackey.m_20998_(ticksDelta);
        if (swimAmount > 0.0f) {
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)swimAmount, (float)lackey.m_146909_(), (float)(-10.0f - lackey.m_146909_()))));
        }
    }
}

