/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.entities;

import com.github.teamfusion.rottencreatures.common.entities.Lackey;
import com.github.teamfusion.rottencreatures.common.entities.SkeletonLackey;
import com.github.teamfusion.rottencreatures.common.entities.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.entities.ZombieLackey;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class DeadBeard
extends SpellcasterZombie {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(DeadBeard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IGNITED = SynchedEntityData.m_135353_(DeadBeard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public DeadBeard(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SpellcasterZombie.CastingSpellGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonLackeysGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_FUSE_ID, (Object)100);
        this.m_20088_().m_135372_(DATA_IGNITED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128376_("Fuse", (short)this.getFuse());
        tag.m_128379_("IsIgnited", this.isIgnited());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFuse(tag.m_128448_("Fuse"));
        this.setIgnited(tag.m_128471_("IsIgnited"));
    }

    public void setFuse(int ticks) {
        this.m_20088_().m_135381_(DATA_FUSE_ID, (Object)ticks);
    }

    public int getFuse() {
        return (Integer)this.m_20088_().m_135370_(DATA_FUSE_ID);
    }

    public void setIgnited(boolean ignited) {
        this.m_20088_().m_135381_(DATA_IGNITED, (Object)ignited);
    }

    public boolean isIgnited() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IGNITED);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
    }

    protected boolean m_5884_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    private void explode() {
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 4.0f, Explosion.BlockInteraction.BREAK);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.m_7472_(source, lootingMultiplier, allowDrops);
        if (allowDrops && this.isIgnited()) {
            this.m_19983_(new ItemStack((ItemLike)RCBlocks.TNT_BARREL.get()));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isIgnited() && (double)this.m_21223_() <= 10.0 && !this.m_21224_()) {
            this.setIgnited(true);
        }
        if (this.isIgnited() && !this.m_21224_()) {
            if (!this.f_19853_.f_46443_ && this.getFuse() == 100 && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            int cooldown = this.getFuse() - 1;
            this.setFuse(cooldown);
            if (cooldown <= 0) {
                this.m_146870_();
                this.explode();
            }
        }
    }

    public boolean m_6779_(LivingEntity entity) {
        return !this.isIgnited() && super.m_6779_(entity);
    }

    protected boolean m_7593_() {
        return false;
    }

    public static boolean checkDeadBeardSpawnRules(EntityType<DeadBeard> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return DeadBeard.m_219019_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }

    class SummonLackeysGoal
    extends SpellcasterZombie.UseSpellGoal {
        private final TargetingConditions lackeyCountTargeting;

        SummonLackeysGoal() {
            super(DeadBeard.this);
            this.lackeyCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int zombies = DeadBeard.this.f_19853_.m_45971_(ZombieLackey.class, this.lackeyCountTargeting, (LivingEntity)DeadBeard.this, DeadBeard.this.m_20191_().m_82400_(16.0)).size();
            int skeletons = DeadBeard.this.f_19853_.m_45971_(SkeletonLackey.class, this.lackeyCountTargeting, (LivingEntity)DeadBeard.this, DeadBeard.this.m_20191_().m_82400_(16.0)).size();
            return DeadBeard.this.f_19796_.m_188503_(4) + 1 > zombies + skeletons;
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel level = (ServerLevel)DeadBeard.this.f_19853_;
            for (int i = 0; i <= DeadBeard.this.f_19796_.m_188503_(4); ++i) {
                Monster lackey;
                BlockPos pos = DeadBeard.this.m_20183_().m_7637_((double)(-2 + DeadBeard.this.f_19796_.m_188503_(5)), -0.8, (double)(-2 + DeadBeard.this.f_19796_.m_188503_(5)));
                Monster monster = lackey = DeadBeard.this.f_19796_.m_188499_() ? (Monster)RCEntityTypes.ZOMBIE_LACKEY.get().m_20615_(DeadBeard.this.f_19853_) : (Monster)RCEntityTypes.SKELETON_LACKEY.get().m_20615_(DeadBeard.this.f_19853_);
                if (!(lackey instanceof Lackey)) continue;
                Lackey lackeyIn = (Lackey)lackey;
                lackey.m_20035_(pos, 0.0f, 0.0f);
                lackey.m_20334_(0.0, 0.5, 0.0);
                DeadBeard.this.f_19853_.m_5594_(null, lackey.m_20183_(), SoundEvents.f_11993_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                lackey.m_6518_((ServerLevelAccessor)level, DeadBeard.this.f_19853_.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
                lackeyIn.setLimitedLife(500);
                level.m_7967_((Entity)lackey);
            }
            DeadBeard.this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 1));
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }
    }
}

