/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.entities;

import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public class PrimedTntBarrel
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(PrimedTntBarrel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;

    public PrimedTntBarrel(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public PrimedTntBarrel(Level level, double x, double y, double z, @Nullable LivingEntity owner) {
        this(RCEntityTypes.TNT_BARREL.get(), level);
        this.m_6034_(x, y, z);
        double offset = level.f_46441_.m_188500_() * (double)6.3f;
        this.m_20334_(-Math.sin(offset) * 0.02, 0.2f, -Math.cos(offset) * 0.02);
        this.setFuse(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.owner = owner;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        int cooldown = this.getFuse() - 1;
        this.setFuse(cooldown);
        if (cooldown <= 0) {
            this.m_146870_();
            if (!this.f_19853_.f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 4.0f, Explosion.BlockInteraction.BREAK);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128376_("Fuse", (short)this.getFuse());
    }

    protected void m_7378_(CompoundTag tag) {
        this.setFuse(tag.m_128448_("Fuse"));
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.15f;
    }

    public void setFuse(int delay) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)delay);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

