/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.capability.ageable;

import com.infamous.sapience.capability.ageable.Ageable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class AgeableProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<Ageable> AGEABLE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Ageable>(){});
    private final LazyOptional<Ageable> instance = LazyOptional.of(Ageable.Impl::new);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == AGEABLE_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        Ageable instance = (Ageable)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty!"));
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Age", instance.getGrowingAge());
        tag.m_128405_("ForcedAge", instance.getForcedAge());
        tag.m_128379_("WasBorn", instance.wasBorn());
        tag.m_128344_("FoodLevel", instance.getFoodLevel());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Ageable instance = (Ageable)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty!"));
        instance.setGrowingAge(nbt.m_128451_("Age"));
        instance.setForcedAge(nbt.m_128451_("ForcedAge"));
        instance.setBorn(nbt.m_128471_("WasBorn"));
        instance.setFoodLevel(nbt.m_128445_("FoodLevel"));
    }
}

