/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mixin;

import com.infamous.sapience.util.BehaviorHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Behavior.class})
public abstract class BehaviorMixin<E extends LivingEntity> {
    @Shadow
    private Behavior.Status f_22523_;
    @Shadow
    @Final
    private int f_22525_;
    @Shadow
    @Final
    private int f_22526_;
    @Shadow
    private long f_22524_;

    @Shadow
    protected abstract boolean m_22543_(E var1);

    @Shadow
    protected abstract boolean m_6114_(ServerLevel var1, E var2);

    @Shadow
    protected abstract void m_6735_(ServerLevel var1, E var2, long var3);

    @Inject(at={@At(value="HEAD")}, method={"tryStart"}, cancellable=true)
    private void handleTryStart(ServerLevel serverLevel, E entity, long gameTime, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof AbstractPiglin || entity instanceof HoglinBase) {
            if (this.m_22543_(entity) && this.enhancedCESC(serverLevel, entity)) {
                this.f_22523_ = Behavior.Status.RUNNING;
                int i = this.f_22525_ + serverLevel.m_213780_().m_188503_(this.f_22526_ + 1 - this.f_22525_);
                this.f_22524_ = gameTime + (long)i;
                if (this.preStart(serverLevel, entity, gameTime)) {
                    this.m_6735_(serverLevel, entity, gameTime);
                    this.postStart(serverLevel, entity, gameTime);
                }
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    private boolean preStart(ServerLevel serverLevel, E entity, long gameTime) {
        return BehaviorHelper.handleSapienceBehaviorPreStart(this.cast(), serverLevel, entity);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/behavior/Behavior;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)V", shift=At.Shift.AFTER)}, method={"tickOrStop"})
    private void postTick(ServerLevel serverLevel, E entity, long gameTime, CallbackInfo ci) {
        BehaviorHelper.handleSapienceBehaviorPostTick(this.cast(), serverLevel, entity, gameTime);
    }

    private void postStart(ServerLevel serverLevel, E entity, long gameTime) {
        BehaviorHelper.handleSapienceBehaviorPostStart(this.cast(), serverLevel, entity);
    }

    private boolean enhancedCESC(ServerLevel serverLevel, E entity) {
        return BehaviorHelper.handleSapienceBehaviorCESC(this.cast(), entity, this.m_6114_(serverLevel, entity));
    }

    private Behavior<?> cast() {
        return (Behavior)this;
    }
}

