/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mixin;

import com.infamous.sapience.util.PiglinReputationType;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PiglinAi.class})
public class PiglinTasksMixin {
    @Inject(at={@At(value="HEAD")}, method={"setAngerTarget"})
    private static void setAngerTarget(AbstractPiglin piglinEntity, LivingEntity target, CallbackInfo callbackInfo) {
        if (Sensor.m_182377_((LivingEntity)piglinEntity, (LivingEntity)target)) {
            piglinEntity.f_19853_.m_7605_((Entity)piglinEntity, (byte)16);
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"angerNearbyPiglins"})
    private static List<Piglin> getPiglinsAngryAtThief(List<Piglin> nearbyPiglinsList, Player playerEntity, boolean checkVisible) {
        List<Piglin> filteredNearbyPiglinsList = nearbyPiglinsList.stream().filter(PiglinTasksHelper::hasIdle).filter(nearbyPiglin -> !checkVisible || BehaviorUtils.m_22667_((LivingEntity)nearbyPiglin, (LivingEntity)playerEntity)).filter(nearbyPiglin -> !ReputationHelper.isAllowedToTouchGold(playerEntity, nearbyPiglin)).collect(Collectors.toList());
        filteredNearbyPiglinsList.forEach(nearbyPiglin -> ReputationHelper.updatePiglinReputation((LivingEntity)nearbyPiglin, PiglinReputationType.GOLD_STOLEN, (Entity)playerEntity));
        return filteredNearbyPiglinsList;
    }
}

