/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mod;

import com.infamous.sapience.capability.ageable.Ageable;
import com.infamous.sapience.capability.ageable.AgeableProvider;
import com.infamous.sapience.capability.emotive.EmotiveProvider;
import com.infamous.sapience.capability.greed.GreedProvider;
import com.infamous.sapience.capability.reputation.ReputationProvider;
import com.infamous.sapience.util.AgeableHelper;
import com.infamous.sapience.util.BrainHelper;
import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.GreedHelper;
import com.infamous.sapience.util.HoglinTasksHelper;
import com.infamous.sapience.util.MobInteraction;
import com.infamous.sapience.util.PiglinReputationType;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReflectionHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sapience")
public class ForgeEventHandler {
    public static final ResourceLocation AGEABLE_LOCATION = new ResourceLocation("sapience", "ageable");
    public static final ResourceLocation GREED_LOCATION = new ResourceLocation("sapience", "greed");
    public static final ResourceLocation REPUTATION_LOCATION = new ResourceLocation("sapience", "reputation");
    public static final ResourceLocation EMOTIVE_LOCATION = new ResourceLocation("sapience", "emotive");
    public static final String REPUTATION_DISPLAY_LOCALIZATION = "sapience.reputation_display";
    private static final ThreadLocal<Map<Piglin, Boolean>> THREADED_SKIP_MOUNT_CHECKS = ThreadLocal.withInitial(HashMap::new);

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Piglin) {
            event.addCapability(AGEABLE_LOCATION, (ICapabilityProvider)new AgeableProvider());
            event.addCapability(GREED_LOCATION, (ICapabilityProvider)new GreedProvider());
            event.addCapability(REPUTATION_LOCATION, (ICapabilityProvider)new ReputationProvider());
            event.addCapability(EMOTIVE_LOCATION, (ICapabilityProvider)new EmotiveProvider());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            if (piglin.m_6162_() && !entity.f_19853_.f_46443_) {
                AgeableHelper.initializeChild((Mob)piglin);
            }
            BrainHelper.retrieveFirstAvailableTask(piglin.m_6274_(), Activity.f_37979_, 16, b -> b instanceof RunOne).map(RunOne.class::cast).ifPresent(PiglinTasksHelper::addAdditionalIdleMovementBehaviors);
            BrainHelper.retrieveFirstAvailableTask(piglin.m_6274_(), Activity.f_37991_, 12, b -> b instanceof RunOne).map(RunOne.class::cast).ifPresent(PiglinTasksHelper::addAdditionalIdleMovementBehaviors);
        }
        if (entity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)entity;
            hoglin.m_21553_(true);
            BrainHelper.addAdditionalTasks(hoglin.m_6274_(), Activity.f_37978_, 2, new Behavior[]{new GoToWantedItem(1.0f, true, 9)});
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity murderer = event.getSource().m_7639_();
        LivingEntity victim = event.getEntity();
        if (murderer == null || murderer.f_19853_.f_46443_) {
            return;
        }
        if (victim instanceof AbstractPiglin) {
            ReputationHelper.makeWitnessesOfMurder(victim, murderer, victim.m_6162_() ? PiglinReputationType.BABY_PIGLIN_KILLED : (victim instanceof PiglinBrute ? PiglinReputationType.BRUTE_KILLED : PiglinReputationType.ADULT_PIGLIN_KILLED), le -> true);
        } else if (victim.m_6095_().m_204039_(PiglinTasksHelper.PIGLINS_HATE)) {
            ReputationHelper.makeWitnessesOfMurder(victim, murderer, ForgeEventHandler.isBoss(victim) ? PiglinReputationType.WITHER_KILLED : PiglinReputationType.WITHER_SKELETON_KILLED, le -> true);
        } else {
            ReputationHelper.makeWitnessesOfMurder(victim, murderer, PiglinReputationType.ALLY_KILLED, le -> ReputationHelper.isAlly(le, victim) || GeneralHelper.isOnSameTeam(le, victim));
        }
    }

    private static boolean isBoss(LivingEntity victim) {
        return victim.m_6095_().m_204039_(Tags.EntityTypes.BOSSES);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onPiglinAttacked(LivingAttackEvent event) {
        Hoglin hoglin;
        if (event.isCanceled()) {
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        LivingEntity victim = event.getEntity();
        if (!(victim instanceof AbstractPiglin) && attacker instanceof LivingEntity) {
            Level level;
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (!(attacker instanceof AbstractPiglin) && (level = victim.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double scale = 16.0;
                AABB aabb = victim.m_20191_().m_82400_(16.0);
                serverLevel.m_6443_(AbstractPiglin.class, aabb, LivingEntity::m_6084_).forEach(p -> {
                    if (ReputationHelper.isAlly((LivingEntity)p, victim) || GeneralHelper.isOnSameTeam((LivingEntity)p, victim)) {
                        ReflectionHelper.callSetAngerTargetIfCloserThanCurrent(p, livingAttacker);
                        ReputationHelper.updatePiglinReputation((LivingEntity)p, PiglinReputationType.ALLY_HURT, attacker);
                    }
                });
            }
        }
        if (victim instanceof Piglin) {
            Piglin piglin = (Piglin)victim;
            if (attacker != null && attacker.f_19853_ instanceof ServerLevel) {
                ReputationHelper.updatePiglinReputation((LivingEntity)piglin, piglin.m_6162_() ? PiglinReputationType.BABY_PIGLIN_HURT : PiglinReputationType.ADULT_PIGLIN_HURT, attacker);
                PiglinTasksHelper.stopHoldingOffHandItem(piglin, false);
                return;
            }
        }
        if (victim instanceof Hoglin && (hoglin = (Hoglin)victim).m_34552_() && attacker instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)attacker;
            HoglinTasksHelper.maybeRetaliate(hoglin, target);
            return;
        }
        if (!(attacker instanceof Hoglin)) return;
        Hoglin hoglin2 = (Hoglin)attacker;
        HoglinTasksHelper.onHitTarget(hoglin2, victim);
    }

    @SubscribeEvent
    public static void onPiglinUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entityLiving = event.getEntity();
        if (entityLiving instanceof Piglin || entityLiving instanceof Hoglin) {
            GeneralHelper.customLooting((Mob)entityLiving);
        }
        if (entityLiving instanceof Piglin) {
            Ageable ageable;
            Piglin piglin = (Piglin)entityLiving;
            ReputationHelper.updateGossip((Mob)piglin);
            if (!(!PiglinTasksHelper.hasConsumableOffhandItem((AbstractPiglin)piglin) || piglin.m_6117_() || PiglinTasksHelper.isPiglinFoodItem(piglin.m_21206_()) && PiglinTasksHelper.hasAteRecently((AbstractPiglin)piglin))) {
                piglin.m_6672_(InteractionHand.OFF_HAND);
            }
            piglin.getCapability(EmotiveProvider.EMOTIVE_CAPABILITY).ifPresent(e -> {
                if (e.getShakeHeadTicks() > 0) {
                    e.setShakeHeadTicks(e.getShakeHeadTicks() - 1);
                }
            });
            if (!piglin.f_19853_.f_46443_ && (ageable = AgeableHelper.getAgeableCapability((Entity)piglin)) != null && piglin.m_6084_()) {
                AgeableHelper.updateSelfAge((Mob)piglin);
                AgeableHelper.updateForcedAge((Mob)piglin);
                AgeableHelper.updateGrowingAge((Mob)piglin);
            }
        }
    }

    private static void sendReputation(Player player, Entity target, int reputation) {
        player.m_213846_((Component)Component.m_237110_((String)REPUTATION_DISPLAY_LOCALIZATION, (Object[])new Object[]{target.m_7755_(), reputation}));
    }

    @SubscribeEvent
    public static void onLivingConversion(LivingConversionEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Piglin) {
            Piglin piglin = (Piglin)livingEntity;
            GreedHelper.dropGreedItems((LivingEntity)piglin);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Piglin) {
            Piglin piglin = (Piglin)livingEntity;
            Collection<ItemStack> greedItemsForDrop = GreedHelper.getGreedItemsForDrop((LivingEntity)piglin);
            Collection drops = event.getDrops();
            greedItemsForDrop.forEach(stack -> {
                ItemEntity itemEntity = new ItemEntity(piglin.f_19853_, piglin.m_20185_(), piglin.m_20186_(), piglin.m_20189_(), stack);
                itemEntity.m_32060_();
                drops.add(itemEntity);
            });
        }
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Piglin piglin;
        Entity entity = event.getEntity();
        if (entity instanceof Piglin && (piglin = (Piglin)entity).m_6162_() && event.isMounting()) {
            Map<Piglin, Boolean> skipMountChecks = THREADED_SKIP_MOUNT_CHECKS.get();
            if (ForgeEventHandler.checkSkipMap((Entity)piglin, skipMountChecks)) {
                return;
            }
            Entity mount = event.getEntityBeingMounted();
            if (mount instanceof Hoglin && mount.m_6095_() != EntityType.f_20456_) {
                event.setCanceled(true);
                skipMountChecks.put(piglin, true);
                piglin.m_20329_(ForgeEventHandler.getTopPassenger(mount, 3));
            }
        }
    }

    private static boolean checkSkipMap(Entity entity, Map<? extends Entity, Boolean> skipMap) {
        if (skipMap.getOrDefault(entity, false).booleanValue()) {
            skipMap.remove(entity);
            return true;
        }
        return false;
    }

    private static Entity getTopPassenger(Entity mount, int index) {
        List passengers = mount.m_20197_();
        return index != 1 && !passengers.isEmpty() ? ForgeEventHandler.getTopPassenger((Entity)passengers.get(0), index - 1) : mount;
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Piglin) {
            Piglin piglin = (Piglin)livingEntity;
            ItemStack itemStack = event.getItem();
            FoodProperties foodProperties = itemStack.getFoodProperties((LivingEntity)piglin);
            if (foodProperties != null) {
                int nutrition = foodProperties.m_38744_();
                piglin.m_5634_((float)nutrition);
                AgeableHelper.increaseFoodLevel((Mob)piglin, nutrition);
                if (!piglin.f_19853_.f_46443_) {
                    PiglinTasksHelper.setAteRecently((AbstractPiglin)piglin);
                    ReputationHelper.updatePreviousInteractorReputation((Mob)piglin, PiglinReputationType.FOOD_GIFT);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        if (!event.getLevel().f_46443_ && ReputationHelper.hasVanillaOrModdedReputationHandling(target) && hand == InteractionHand.MAIN_HAND && stack.m_41619_() && player.m_36341_()) {
            int n;
            if (target instanceof Villager) {
                Villager villager = (Villager)target;
                n = villager.m_35532_(player);
            } else {
                n = ReputationHelper.getEntityReputation(target, (Entity)player);
            }
            int reputation = n;
            ForgeEventHandler.sendReputation(player, target, reputation);
        }
        if (player.m_36341_()) {
            return;
        }
        if (target instanceof Piglin) {
            Piglin piglin = (Piglin)target;
            InteractionResult interactOn = GeneralHelper.interactOn(player, piglin, hand, PiglinTasksHelper::handlePiglinInteraction);
            ForgeEventHandler.cancelWithResult(event, interactOn);
            if (interactOn.m_19077_()) {
                PiglinTasksHelper.handlePiglinInteractPost(piglin, player, interactOn);
            }
        } else if (target instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)target;
            if (HoglinTasksHelper.isHoglinFoodItem(stack)) {
                InteractionResult interactOn = GeneralHelper.interactOn(player, hoglin, hand, GeneralHelper::handleGiveAnimalFood);
                ForgeEventHandler.cancelWithResult(event, interactOn);
                if (interactOn.m_19077_()) {
                    HoglinTasksHelper.handleHoglinInteractPost(hoglin, player, hand, InteractionResult.PASS);
                    hoglin.m_21530_();
                }
            } else if (stack.m_150930_(Items.f_41954_)) {
                InteractionResult interactOn = GeneralHelper.interactOn(player, hoglin, hand, MobInteraction::pass);
                ForgeEventHandler.cancelWithResult(event, interactOn);
                HoglinTasksHelper.handleHoglinInteractPost(hoglin, player, hand, InteractionResult.PASS);
            }
        }
    }

    private static void cancelWithResult(PlayerInteractEvent.EntityInteract event, InteractionResult result) {
        event.setCanceled(true);
        event.setCancellationResult(result);
    }
}

