/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.tasks;

import com.google.common.collect.ImmutableMap;
import com.infamous.sapience.mod.ModMemoryModuleTypes;
import com.infamous.sapience.util.HoglinTasksHelper;
import com.infamous.sapience.util.PiglinTasksHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class FeedHoglinsTask<T extends Piglin>
extends Behavior<T> {
    public FeedHoglinsTask() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ModMemoryModuleTypes.FED_RECENTLY.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26340_, (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)ModMemoryModuleTypes.NEAREST_VISIBLE_ADULT_HOGLIN.get()), (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26344_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26334_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel serverWorld, T owner) {
        return PiglinTasksHelper.hasNotFedRecently(owner) && Items.f_41954_.m_204114_().containsTag(HoglinTasksHelper.HOGLIN_FOOD_ITEMS);
    }

    protected boolean canStillUse(ServerLevel serverWorld, T owner, long gameTime) {
        return this.checkExtraStartConditions(serverWorld, owner);
    }

    protected void start(ServerLevel serverWorld, T owner, long gameTime) {
        Optional optionalBabyHoglin;
        boolean foundAdult = false;
        Optional optionalAdultHoglin = owner.m_6274_().m_21952_((MemoryModuleType)ModMemoryModuleTypes.NEAREST_VISIBLE_ADULT_HOGLIN.get());
        if (optionalAdultHoglin.isPresent() && ((Hoglin)optionalAdultHoglin.get()).m_146764_() == 0) {
            foundAdult = true;
            BehaviorUtils.m_22602_(owner, (LivingEntity)((LivingEntity)optionalAdultHoglin.get()), (float)0.5f);
        }
        if (!foundAdult && (optionalBabyHoglin = owner.m_6274_().m_21952_(MemoryModuleType.f_26344_)).isPresent()) {
            optionalBabyHoglin.ifPresent(hoglinEntity -> BehaviorUtils.m_22602_((LivingEntity)owner, (LivingEntity)hoglinEntity, (float)0.5f));
        }
    }

    protected void tick(ServerLevel serverWorld, T owner, long gameTime) {
        Optional optionalBabyHoglin;
        boolean foundAdult = false;
        Optional optionalAdultHoglin = owner.m_6274_().m_21952_((MemoryModuleType)ModMemoryModuleTypes.NEAREST_VISIBLE_ADULT_HOGLIN.get());
        if (optionalAdultHoglin.isPresent() && ((Hoglin)optionalAdultHoglin.get()).m_146764_() == 0 && owner.m_20280_((Entity)optionalAdultHoglin.get()) <= 5.0) {
            foundAdult = true;
            owner.m_6674_(InteractionHand.OFF_HAND);
            BehaviorUtils.m_22613_(owner, (ItemStack)new ItemStack((ItemLike)Items.f_41954_), (Vec3)((Hoglin)optionalAdultHoglin.get()).m_20182_());
            PiglinTasksHelper.setFedRecently(owner);
        }
        if (!foundAdult && (optionalBabyHoglin = owner.m_6274_().m_21952_(MemoryModuleType.f_26344_)).isPresent() && owner.m_20280_((Entity)optionalBabyHoglin.get()) <= 5.0) {
            owner.m_6674_(InteractionHand.OFF_HAND);
            BehaviorUtils.m_22613_(owner, (ItemStack)new ItemStack((ItemLike)Items.f_41954_), (Vec3)((Hoglin)optionalBabyHoglin.get()).m_20182_());
            PiglinTasksHelper.setFedRecently(owner);
        }
    }
}

