/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.infamous.sapience.util.GreedHelper;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;

public class ShareGoldTask<T extends Piglin>
extends Behavior<T> {
    private Set<Item> allyDesiredItems = ImmutableSet.of();

    public ShareGoldTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel serverWorld, T owner) {
        LivingEntity ally;
        EntityType entityType = owner.m_6095_();
        boolean isSharingGold = GreedHelper.isSharingGold(owner);
        boolean hasGold = GreedHelper.doesGreedInventoryHaveGold(owner);
        boolean ownerIsAdult = !owner.m_6162_();
        boolean hasOpenOffhandSlot = true;
        if (owner.m_6274_().m_21952_(MemoryModuleType.f_26374_).isPresent() && (ally = (LivingEntity)owner.m_6274_().m_21952_(MemoryModuleType.f_26374_).get()) instanceof Piglin && !PiglinTasksHelper.hasOpenOffhandSlot((Piglin)ally)) {
            hasOpenOffhandSlot = false;
        }
        return isSharingGold && hasGold && ownerIsAdult && hasOpenOffhandSlot && BehaviorUtils.m_22639_((Brain)owner.m_6274_(), (MemoryModuleType)MemoryModuleType.f_26374_, (EntityType)entityType);
    }

    protected boolean canStillUse(ServerLevel serverWorld, T owner, long gameTime) {
        return this.checkExtraStartConditions(serverWorld, owner);
    }

    protected void start(ServerLevel serverWorld, T owner, long gameTime) {
        if (owner.m_6274_().m_21952_(MemoryModuleType.f_26374_).isPresent()) {
            LivingEntity ally = (LivingEntity)owner.m_6274_().m_21952_(MemoryModuleType.f_26374_).get();
            BehaviorUtils.m_22602_(owner, (LivingEntity)ally, (float)0.5f);
            this.allyDesiredItems = GreedHelper.getDesiredItems(ally);
        }
    }

    protected void tick(ServerLevel serverWorld, T owner, long gameTime) {
        LivingEntity ally;
        if (owner.m_6274_().m_21952_(MemoryModuleType.f_26374_).isPresent() && owner.m_20280_((Entity)(ally = (LivingEntity)owner.m_6274_().m_21952_(MemoryModuleType.f_26374_).get())) <= 5.0) {
            BehaviorUtils.m_22602_(owner, (LivingEntity)ally, (float)0.5f);
            ReputationHelper.spreadGossip(owner, ally, gameTime);
            if (!this.allyDesiredItems.isEmpty() && ally instanceof Piglin) {
                GreedHelper.giveAllyDesiredItem(this.allyDesiredItems, owner, (Piglin)ally);
            }
        }
    }

    protected void stop(ServerLevel serverWorld, T owner, long gameTime) {
        owner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
    }
}

