/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReflectionHelper;
import com.infamous.sapience.util.ZoglinTasksHelper;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.RememberIfHoglinWasKilled;
import net.minecraft.world.entity.monster.piglin.StartAdmiringItemIfSeen;
import net.minecraft.world.entity.monster.piglin.StopHoldingItemIfNoLongerAdmiring;
import net.minecraft.world.level.GameRules;

public class BehaviorHelper {
    public static boolean handleSapienceBehaviorCESC(Behavior<?> behavior, LivingEntity entity, boolean canStartVanilla) {
        if (behavior instanceof StartAdmiringItemIfSeen) {
            Optional itemMemory = entity.m_6274_().m_21952_(MemoryModuleType.f_26332_);
            return itemMemory.map(ie -> canStartVanilla || PiglinTasksHelper.isBarterItem(ie.m_32055_()) || PiglinTasksHelper.isPiglinFoodItem(ie.m_32055_())).orElse(canStartVanilla);
        }
        if (behavior instanceof StopHoldingItemIfNoLongerAdmiring && entity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            return canStartVanilla && !PiglinTasksHelper.hasConsumableOffhandItem(piglin);
        }
        if (behavior instanceof StartAttacking && entity instanceof Zoglin) {
            Zoglin zoglin = (Zoglin)entity;
            return ZoglinTasksHelper.findNearestValidAttackTarget(zoglin).filter(arg_0 -> ((Zoglin)zoglin).m_6779_(arg_0)).isPresent();
        }
        return canStartVanilla;
    }

    public static void handleSapienceBehaviorPostTick(Behavior<?> behavior, ServerLevel serverLevel, LivingEntity entity, long gameTime) {
        if (behavior instanceof AnimalMakeLove) {
            AnimalMakeLove animalMakeLove = (AnimalMakeLove)behavior;
            if (entity instanceof Animal) {
                Animal animal = (Animal)entity;
                GeneralHelper.getBreedTarget(animal).ifPresent(a -> {
                    if (entity.m_19950_((Entity)a, 3.0) && gameTime < ReflectionHelper.getSpawnChildAtTime(animalMakeLove) && entity.m_217043_().m_188503_(35) == 0) {
                        serverLevel.m_7605_((Entity)entity, (byte)18);
                        serverLevel.m_7605_((Entity)a, (byte)18);
                    }
                });
            }
        }
    }

    public static void handleSapienceBehaviorPostStart(Behavior<?> behavior, ServerLevel serverLevel, LivingEntity entity) {
        if (behavior instanceof AnimalMakeLove) {
            Animal animal;
            Optional<? extends Animal> nearestMate;
            AnimalMakeLove animalMakeLove = (AnimalMakeLove)behavior;
            if (entity instanceof Animal && (nearestMate = GeneralHelper.findValidBreedPartner(animal = (Animal)entity, ReflectionHelper.getPartnerType(animalMakeLove))).isPresent()) {
                Animal partner = nearestMate.get();
                serverLevel.m_7605_((Entity)entity, (byte)12);
                serverLevel.m_7605_((Entity)partner, (byte)12);
            }
        }
    }

    public static boolean handleSapienceBehaviorPreStart(Behavior<?> behavior, ServerLevel serverLevel, LivingEntity entity) {
        EraseMemoryIf emi;
        if (behavior instanceof RememberIfHoglinWasKilled) {
            entity.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(le -> {
                if (le.m_6095_().m_204039_(PiglinTasksHelper.PIGLINS_HUNT) && le.m_21224_()) {
                    entity.m_6274_().m_21882_(MemoryModuleType.f_26340_, (Object)true, (long)PiglinTasksHelper.TIME_BETWEEN_HUNTS.m_214085_(entity.f_19853_.f_46441_));
                }
            });
            return false;
        }
        if (behavior instanceof StartAttacking && entity instanceof Zoglin) {
            Zoglin zoglin = (Zoglin)entity;
            ZoglinTasksHelper.findNearestValidAttackTarget(zoglin).ifPresent(le -> ZoglinTasksHelper.setAttackTarget(zoglin, le));
            return false;
        }
        if (behavior instanceof StopHoldingItemIfNoLongerAdmiring && entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            PiglinTasksHelper.stopHoldingOffHandItem(piglin, true);
            return false;
        }
        if (behavior instanceof StartCelebratingIfTargetDead) {
            StartCelebratingIfTargetDead scitd = (StartCelebratingIfTargetDead)behavior;
            if (entity instanceof Piglin) {
                Piglin piglin = (Piglin)entity;
                GeneralHelper.getAttackTarget((LivingEntity)piglin).ifPresent(le -> {
                    if (PiglinTasksHelper.wantsToDance((LivingEntity)piglin, le)) {
                        piglin.m_6274_().m_21882_(MemoryModuleType.f_26342_, (Object)true, (long)ReflectionHelper.getCelebrateDuration(scitd));
                    }
                    piglin.m_6274_().m_21882_(MemoryModuleType.f_26341_, (Object)le.m_20183_(), (long)ReflectionHelper.getCelebrateDuration(scitd));
                    if (le.m_6095_() != EntityType.f_20532_ || serverLevel.m_46469_().m_46207_(GameRules.f_46126_)) {
                        piglin.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                        piglin.m_6274_().m_21936_(MemoryModuleType.f_26334_);
                    }
                });
                return false;
            }
        }
        if (behavior instanceof EraseMemoryIf && ReflectionHelper.getMemoryTypeToErase(emi = (EraseMemoryIf)behavior) == MemoryModuleType.f_26383_ && entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            return PiglinTasksHelper.wantsToStopFleeing(piglin);
        }
        return true;
    }
}

