/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.Sapience;
import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.capability.greed.Greed;
import com.infamous.sapience.capability.greed.GreedProvider;
import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.PiglinTasksHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;

public class GreedHelper {
    public static final String BARTERED = "Bartered";

    private static Greed getGreedCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(GreedProvider.GREED_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (Greed)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the greed capability from the Entity!"));
        }
        Sapience.LOGGER.error("Couldn't get the greed capability from the Entity in GreedHelper#getAgeableCapability!");
        return null;
    }

    public static boolean doesGreedInventoryHaveGold(Mob mobEntity) {
        Greed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            return GeneralHelper.hasAnyOf((Container)greed.getGreedInventory(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        }
        return false;
    }

    public static void dropGreedItems(LivingEntity mobEntity) {
        Greed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            GreedHelper.getGreedItemsForDrop(mobEntity).forEach(arg_0 -> ((LivingEntity)mobEntity).m_19983_(arg_0));
        }
    }

    public static Collection<ItemStack> getGreedItemsForDrop(LivingEntity mobEntity) {
        Greed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            return greed.getGreedInventory().m_19195_().stream().filter(GreedHelper::wasNotTraded).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean wasNotTraded(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        return compoundNBT != null && !compoundNBT.m_128471_(BARTERED);
    }

    public static boolean isSharingGold(Mob mobEntity) {
        Greed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            return greed.isSharingGold();
        }
        return false;
    }

    private static int getIngotRequirement(EquipmentSlot slotType) {
        switch (slotType) {
            case HEAD: {
                return 5;
            }
            case CHEST: {
                return 8;
            }
            case LEGS: {
                return 7;
            }
            case FEET: {
                return 4;
            }
            case MAINHAND: {
                return 2;
            }
        }
        return 0;
    }

    private static EquipmentSlot getSlotForItem(Item item) {
        if (item == Items.f_42476_) {
            return EquipmentSlot.HEAD;
        }
        if (item == Items.f_42477_) {
            return EquipmentSlot.CHEST;
        }
        if (item == Items.f_42478_) {
            return EquipmentSlot.LEGS;
        }
        if (item == Items.f_42479_) {
            return EquipmentSlot.FEET;
        }
        if (item == Items.f_42430_) {
            return EquipmentSlot.MAINHAND;
        }
        return EquipmentSlot.OFFHAND;
    }

    private static ItemStack getEquipmentForIngotCount(int ingotCount) {
        switch (ingotCount) {
            case 5: {
                return new ItemStack((ItemLike)Items.f_42476_);
            }
            case 8: {
                return new ItemStack((ItemLike)Items.f_42477_);
            }
            case 7: {
                return new ItemStack((ItemLike)Items.f_42478_);
            }
            case 4: {
                return new ItemStack((ItemLike)Items.f_42479_);
            }
            case 2: {
                return new ItemStack((ItemLike)Items.f_42430_);
            }
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack craftArmorFromGreedInventory(Mob mobEntity, EquipmentSlot slotType) {
        Greed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            int ingotRequirement = GreedHelper.getIngotRequirement(slotType);
            if (ingotRequirement == 0) {
                return ItemStack.f_41583_;
            }
            int ingotsFound = 0;
            ArrayList<ItemStack> usedStacks = new ArrayList<ItemStack>();
            for (int slotIndex = 0; slotIndex < greed.getGreedInventory().m_6643_(); ++slotIndex) {
                ItemStack stackFromSlot = greed.getGreedInventory().m_8020_(slotIndex);
                if (!stackFromSlot.m_204117_(Tags.Items.INGOTS_GOLD) || stackFromSlot.m_41619_()) continue;
                for (int i = 1; i <= stackFromSlot.m_41613_(); ++i) {
                    usedStacks.add(stackFromSlot.m_41620_(1));
                    if (++ingotsFound != ingotRequirement) continue;
                    ItemStack craftedEquipment = GreedHelper.getEquipmentForIngotCount(ingotsFound);
                    if (craftedEquipment.m_41619_()) {
                        for (ItemStack itemStack : usedStacks) {
                            greed.getGreedInventory().m_19173_(itemStack);
                        }
                    }
                    return craftedEquipment;
                }
            }
            for (ItemStack itemStack : usedStacks) {
                greed.getGreedInventory().m_19173_(itemStack);
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public static void checkCraftEquipment(Piglin piglinEntity) {
        Greed greed = GreedHelper.getGreedCapability((Entity)piglinEntity);
        if (greed != null && !greed.getGreedInventory().m_7983_()) {
            int heldEquipmentAmount = 0;
            boolean didCraft = false;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack craftedEquipment;
                if (slot == EquipmentSlot.OFFHAND) continue;
                ItemStack stackFromSlot = piglinEntity.m_6844_(slot);
                if (!stackFromSlot.m_41619_()) {
                    ItemStack craftedEquipment2;
                    boolean isValidEquipment = (Boolean)SapienceConfig.COMMON.PIGLINS_PREFER_CRAFTED_EQUIPMENT.get() != false ? GreedHelper.isGoldArmorOrWeapon(stackFromSlot) : GreedHelper.isArmorOrWeapon(stackFromSlot);
                    boolean isCrossbow = stackFromSlot.m_41781_();
                    if (isValidEquipment || isCrossbow) {
                        ++heldEquipmentAmount;
                        continue;
                    }
                    if (didCraft || (craftedEquipment2 = GreedHelper.craftArmorFromGreedInventory((Mob)piglinEntity, slot)).m_41619_()) continue;
                    PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglin)piglinEntity, craftedEquipment2);
                    PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
                    PiglinTasksHelper.clearWalkPath((AbstractPiglin)piglinEntity);
                    didCraft = true;
                    ++heldEquipmentAmount;
                    continue;
                }
                if (didCraft || (craftedEquipment = GreedHelper.craftArmorFromGreedInventory((Mob)piglinEntity, slot)).m_41619_()) continue;
                PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglin)piglinEntity, craftedEquipment);
                PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
                PiglinTasksHelper.clearWalkPath((AbstractPiglin)piglinEntity);
                didCraft = true;
                ++heldEquipmentAmount;
            }
            greed.setSharingGold(heldEquipmentAmount >= 5);
        }
    }

    private static boolean isArmorOrWeapon(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem || stack.m_41720_() instanceof TieredItem;
    }

    private static boolean isGoldArmorOrWeapon(ItemStack stack) {
        if (stack.m_41720_() instanceof ArmorItem) {
            return ((ArmorItem)stack.m_41720_()).m_40401_() == ArmorMaterials.GOLD;
        }
        if (stack.m_41720_() instanceof TieredItem) {
            return ((TieredItem)stack.m_41720_()).m_43314_() == Tiers.GOLD;
        }
        return false;
    }

    public static ItemStack addGreedItemToGreedInventory(Mob mobEntity, ItemStack stackToAdd, boolean didBarter) {
        Greed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            if (!stackToAdd.m_41619_()) {
                SimpleContainer greedInventory = greed.getGreedInventory();
                if (stackToAdd.m_204117_(Tags.Items.INGOTS_GOLD)) {
                    return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, stackToAdd, didBarter);
                }
                if (stackToAdd.m_204117_(Tags.Items.STORAGE_BLOCKS_GOLD)) {
                    int blockCount = stackToAdd.m_41613_();
                    ItemStack blocksToIngotsStack = new ItemStack((ItemLike)Items.f_42417_, blockCount * 9);
                    blocksToIngotsStack.m_41751_(stackToAdd.m_41783_());
                    return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, blocksToIngotsStack, didBarter);
                }
                if (stackToAdd.m_204117_(Tags.Items.NUGGETS_GOLD)) {
                    return GreedHelper.addGoldNuggetsToGreedInventory(mobEntity, stackToAdd, greedInventory, didBarter);
                }
                return stackToAdd;
            }
            return stackToAdd;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack addGoldNuggetsToGreedInventory(Mob mobEntity, ItemStack stackToAdd, SimpleContainer greedInventory, boolean didBarter) {
        boolean canAutoMerge;
        int nuggetCount = stackToAdd.m_41613_();
        boolean bl = canAutoMerge = nuggetCount % 9 == 0;
        if (canAutoMerge) {
            ItemStack goldIngotStack = new ItemStack((ItemLike)Items.f_42417_, nuggetCount / 9);
            goldIngotStack.m_41751_(stackToAdd.m_41783_());
            return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, goldIngotStack, didBarter);
        }
        for (int slotIndex = 0; slotIndex < greedInventory.m_6643_(); ++slotIndex) {
            ItemStack stackInSlot = greedInventory.m_8020_(slotIndex);
            if (!stackInSlot.m_204117_(Tags.Items.NUGGETS_GOLD) || stackInSlot.m_41613_() + nuggetCount > stackInSlot.m_41741_()) continue;
            stackToAdd.m_41774_(nuggetCount);
            stackInSlot.m_41769_(nuggetCount);
            if (stackInSlot.m_41613_() % 9 == 0) {
                ItemStack goldIngotStack = new ItemStack((ItemLike)Items.f_42417_, nuggetCount / 9);
                goldIngotStack.m_41751_(stackToAdd.m_41783_());
                greedInventory.m_6836_(slotIndex, goldIngotStack);
                break;
            }
            if (!stackToAdd.m_41619_()) continue;
            return stackToAdd;
        }
        return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, stackToAdd, didBarter);
    }

    public static ItemStack addStackToGreedInventoryCheckBartered(Mob mobEntity, ItemStack stack, boolean didBarter) {
        Greed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            if (didBarter) {
                CompoundTag compoundNBT = stack.m_41784_();
                compoundNBT.m_128379_(BARTERED, true);
            }
            return greed.getGreedInventory().m_19173_(stack);
        }
        return stack;
    }

    public static Set<Item> getDesiredItems(LivingEntity ally) {
        HashSet<Item> desiredItems = new HashSet<Item>();
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            if (slotType == EquipmentSlot.OFFHAND) continue;
            int ingotRequirement = GreedHelper.getIngotRequirement(slotType);
            ItemStack desiredItemStack = GreedHelper.getEquipmentForIngotCount(ingotRequirement);
            Item desiredItem = desiredItemStack.m_41720_();
            ItemStack stackFromSlot = ally.m_6844_(slotType);
            if (!stackFromSlot.m_41619_()) {
                boolean isValidEquipment;
                boolean isCrossbow = stackFromSlot.m_41781_();
                boolean bl = isValidEquipment = (Boolean)SapienceConfig.COMMON.PIGLINS_PREFER_CRAFTED_EQUIPMENT.get() != false ? GreedHelper.isGoldArmorOrWeapon(stackFromSlot) : GreedHelper.isArmorOrWeapon(stackFromSlot);
                if (isValidEquipment || isCrossbow || desiredItemStack.m_41619_()) continue;
                desiredItems.add(desiredItem);
                continue;
            }
            if (desiredItemStack.m_41619_()) continue;
            desiredItems.add(desiredItem);
        }
        return desiredItems;
    }

    public static void giveAllyDesiredItem(Set<Item> allyDesiredItems, Piglin owner, Piglin ally) {
        if (!allyDesiredItems.isEmpty()) {
            ItemStack craftedItem;
            EquipmentSlot slotType;
            Item desiredItem = null;
            Iterator<Item> iterator = allyDesiredItems.iterator();
            if (iterator.hasNext()) {
                Item item;
                desiredItem = item = iterator.next();
            }
            if ((slotType = GreedHelper.getSlotForItem(desiredItem)) != EquipmentSlot.OFFHAND && !(craftedItem = GreedHelper.craftArmorFromGreedInventory((Mob)owner, slotType)).m_41619_()) {
                GreedHelper.checkCraftEquipment(owner);
                owner.m_6674_(InteractionHand.OFF_HAND);
                PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglin)ally, craftedItem);
                PiglinTasksHelper.setAdmiringItem((LivingEntity)ally);
                PiglinTasksHelper.clearWalkPath((AbstractPiglin)ally);
                ally.f_19853_.m_7605_((Entity)ally, (byte)8);
                allyDesiredItems.remove(desiredItem);
            }
        }
    }
}

