/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class HoglinTasksHelper {
    public static final TagKey<Item> HOGLIN_FOOD_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("sapience", "hoglin_food_items"));
    public static final int BREEDING_ID = 18;
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);

    public static boolean canPickUpItemStack(Animal animalEntity, ItemStack itemStack) {
        BlockItem blockItem;
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_().m_204297_().containsTag(BlockTags.f_13084_)) {
            return false;
        }
        if (animalEntity.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
            return false;
        }
        if (animalEntity.m_6898_(itemStack)) {
            return !HoglinTasksHelper.hasAteRecently(animalEntity);
        }
        return false;
    }

    public static void pickUpHoglinItem(Animal animalEntity, ItemEntity itemEntity) {
        animalEntity.m_7938_((Entity)itemEntity, 1);
        ItemStack temptationStack = itemEntity.m_32055_();
        ItemStack pickupStack = temptationStack.m_41620_(1);
        if (temptationStack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(temptationStack);
        }
        if (!HoglinTasksHelper.hasAteRecently(animalEntity)) {
            HoglinTasksHelper.setAteRecently(animalEntity);
        }
        int growingAge = animalEntity.m_146764_();
        Level animalWorld = animalEntity.f_19853_;
        if (!animalWorld.f_46443_ && growingAge == 0 && !animalEntity.m_27593_()) {
            animalEntity.m_27595_(null);
        } else if (!animalWorld.f_46443_ && animalEntity.m_6162_()) {
            animalEntity.m_146740_((int)((float)(-growingAge / 20) * 0.1f), true);
        }
    }

    private static boolean hasAteRecently(Animal animalEntity) {
        return animalEntity.m_6274_().m_21874_(MemoryModuleType.f_26355_);
    }

    public static boolean isHoglinFoodItem(ItemStack item) {
        return item.m_204117_(HOGLIN_FOOD_ITEMS);
    }

    public static void setAteRecently(Animal animalEntity) {
        animalEntity.m_6274_().m_21882_(MemoryModuleType.f_26355_, (Object)true, 200L);
    }

    public static void additionalSensorLogic(Hoglin entity) {
        Brain brain = entity.m_6274_();
        Optional<Object> optionalNearestPiglin = Optional.empty();
        int visiblePiglinCount = 0;
        NearestVisibleLivingEntities nvle = brain.m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
        for (LivingEntity livingEntity : nvle.m_186123_(le -> !le.m_6162_())) {
            if (!(livingEntity instanceof AbstractPiglin)) continue;
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            ++visiblePiglinCount;
            if (!optionalNearestPiglin.isEmpty()) continue;
            optionalNearestPiglin = Optional.of(piglin);
        }
        brain.m_21886_(MemoryModuleType.f_26350_, optionalNearestPiglin);
        brain.m_21879_(MemoryModuleType.f_26352_, (Object)visiblePiglinCount);
    }

    public static void handleHoglinInteractPost(Hoglin hoglin, Player playerEntity, InteractionHand hand, InteractionResult interactionResult) {
        ItemStack stack = playerEntity.m_21120_(hand);
        if (interactionResult.m_19077_()) {
            if (hoglin.m_6898_(stack) && !hoglin.f_19853_.f_46443_) {
                HoglinTasksHelper.setAteRecently((Animal)hoglin);
            } else if (hoglin.f_19853_.f_46443_) {
                hoglin.m_5496_(SoundEvents.f_11956_, 1.0f, hoglin.m_6100_());
            }
        } else if (hoglin.f_19853_.f_46443_) {
            hoglin.m_5496_(SoundEvents.f_11957_, 1.0f, hoglin.m_6100_());
        }
    }

    public static void maybeRetaliate(Hoglin hoglin, LivingEntity attacker) {
        if (!(hoglin.m_6274_().m_21954_(Activity.f_37991_) && attacker instanceof Piglin || attacker instanceof Hoglin || BehaviorUtils.m_22598_((LivingEntity)hoglin, (LivingEntity)attacker, (double)4.0) || !Sensor.m_148312_((LivingEntity)hoglin, (LivingEntity)attacker))) {
            HoglinTasksHelper.setAttackTarget(hoglin, attacker);
            HoglinTasksHelper.broadcastAttackTarget(hoglin, attacker);
        }
    }

    private static void setAttackTarget(Hoglin hoglin, LivingEntity target) {
        Brain brain = hoglin.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26326_);
        brain.m_21936_(MemoryModuleType.f_26375_);
        brain.m_21882_(MemoryModuleType.f_26372_, (Object)target, 200L);
    }

    private static void broadcastAttackTarget(Hoglin hoglin, LivingEntity target) {
        HoglinTasksHelper.getVisibleAdultHoglins(hoglin).forEach(h -> HoglinTasksHelper.setAttackTargetIfCloserThanCurrent(h, target));
    }

    private static void setAttackTargetIfCloserThanCurrent(Hoglin hoglin, LivingEntity target) {
        if (!HoglinTasksHelper.isPacified(hoglin)) {
            Optional currentTarget = hoglin.m_6274_().m_21952_(MemoryModuleType.f_26372_);
            LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)hoglin, (Optional)currentTarget, (LivingEntity)target);
            HoglinTasksHelper.setAttackTarget(hoglin, livingentity);
        }
    }

    private static List<Hoglin> getVisibleAdultHoglins(Hoglin hoglin) {
        return (List)hoglin.m_6274_().m_21952_(MemoryModuleType.f_26348_).orElse(ImmutableList.of());
    }

    protected static boolean isPacified(Hoglin hoglin) {
        return hoglin.m_6274_().m_21874_(MemoryModuleType.f_26357_);
    }

    public static void onHitTarget(Hoglin hoglin, LivingEntity target) {
        if (!hoglin.m_6162_()) {
            if (target instanceof Piglin && HoglinTasksHelper.piglinsOutnumberHoglins(hoglin)) {
                HoglinTasksHelper.setAvoidTarget(hoglin, target);
                HoglinTasksHelper.broadcastRetreat(hoglin, target);
            } else {
                HoglinTasksHelper.broadcastAttackTarget(hoglin, target);
            }
        }
    }

    private static void broadcastRetreat(Hoglin hoglin, LivingEntity target) {
        HoglinTasksHelper.getVisibleAdultHoglins(hoglin).forEach(p_34590_ -> HoglinTasksHelper.retreatFromNearestTarget(p_34590_, target));
    }

    private static void retreatFromNearestTarget(Hoglin hoglin, LivingEntity target) {
        Brain brain = hoglin.m_6274_();
        LivingEntity $$2 = BehaviorUtils.m_22625_((LivingEntity)hoglin, (Optional)brain.m_21952_(MemoryModuleType.f_26383_), (LivingEntity)target);
        $$2 = BehaviorUtils.m_22625_((LivingEntity)hoglin, (Optional)brain.m_21952_(MemoryModuleType.f_26372_), (LivingEntity)$$2);
        HoglinTasksHelper.setAvoidTarget(hoglin, $$2);
    }

    private static void setAvoidTarget(Hoglin hoglin, LivingEntity target) {
        hoglin.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        hoglin.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        hoglin.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)RETREAT_DURATION.m_214085_(hoglin.f_19853_.f_46441_));
    }

    private static boolean piglinsOutnumberHoglins(Hoglin hoglin) {
        int j;
        if (hoglin.m_6162_()) {
            return false;
        }
        int i = hoglin.m_6274_().m_21952_(MemoryModuleType.f_26352_).orElse(0);
        return i > (j = hoglin.m_6274_().m_21952_(MemoryModuleType.f_26353_).orElse(0) + 1);
    }

    public static boolean wantsToPickUp(Hoglin hoglin, ItemStack itemStack) {
        return hoglin.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && hoglin.m_21531_() && HoglinTasksHelper.canPickUpItemStack((Animal)hoglin, itemStack);
    }
}

