/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.shulkerboxslot;

import com.illusivesoulworks.shulkerboxslot.ShulkerBoxSlotCommonMod;
import com.illusivesoulworks.shulkerboxslot.client.CurioShulkerBoxRenderer;
import com.illusivesoulworks.shulkerboxslot.client.ForgeClientEventListener;
import com.illusivesoulworks.shulkerboxslot.client.ShulkerBoxSlotKeyRegistry;
import com.illusivesoulworks.shulkerboxslot.common.CurioShulkerBox;
import com.illusivesoulworks.shulkerboxslot.common.ShulkerBoxSlotForgeNetwork;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="shulkerboxslot")
public class ShulkerBoxSlotForgeMod {
    public ShulkerBoxSlotForgeMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::enqueue);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        ShulkerBoxSlotForgeNetwork.setup();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        ForgeClientEventListener.setup();
        for (Item shulkerBox : ShulkerBoxSlotCommonMod.getShulkerBoxes()) {
            CuriosRendererRegistry.register((Item)shulkerBox, CurioShulkerBoxRenderer::new);
        }
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (ShulkerBoxSlotCommonMod.isShulkerBox(stack.m_41720_())) {
            final CurioShulkerBox curioShulkerBox = new CurioShulkerBox(stack);
            stack.m_41698_("BlockEntityTag");
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> curioShulkerBox);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }

    @Mod.EventBusSubscriber(modid="shulkerboxslot", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent evt) {
            ShulkerBoxSlotKeyRegistry.setup();
            evt.register(ShulkerBoxSlotKeyRegistry.openShulkerBox);
        }
    }
}

