/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.core;

import io.github.mortuusars.sootychimneys.config.CommonConfig;
import io.github.mortuusars.sootychimneys.core.TimeOfDay;
import io.github.mortuusars.sootychimneys.core.Weather;
import io.github.mortuusars.sootychimneys.core.Wind;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WindGetter {
    private static final Wind _wind = new Wind(0.0, 0.0f);

    public static Wind getWind() {
        return _wind;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)CommonConfig.WIND_ENABLED.get()).booleanValue()) {
            return;
        }
        Level level = event.player.m_9236_();
        if (level.m_5776_() && level.m_46467_() % 5L == 0L) {
            WindGetter.updateWind(level);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent event) {
        Level level = event.getLevel();
        event.getEntity().m_5661_((Component)Component.m_237113_((String)(_wind + "\nTime of day: " + TimeOfDay.of(level) + "\nWeather: " + Weather.of(level))), true);
    }

    private static void updateWind(Level level) {
        RandomSource random = level.f_46441_;
        double addDegrees = Math.exp(random.m_188500_() * 3.5) * (double)(random.m_188499_() ? -1 : 1);
        _wind.update(addDegrees, WindGetter.getWindStrengthChange(level));
    }

    private static float getWindStrengthChange(Level level) {
        TimeOfDay timeOfDay = TimeOfDay.of(level);
        Weather weather = Weather.of(level);
        RandomSource random = level.m_213780_();
        if (weather == Weather.THUNDER) {
            return random.m_188501_() * 0.2f - 0.1f + Math.max(0.0f, 0.4f - _wind.getStrength());
        }
        if (weather == Weather.RAIN) {
            return random.m_188501_() * 0.18f - 0.09f + Math.max(0.0f, 0.2f - _wind.getStrength()) - Math.max(0.0f, _wind.getStrength() - 0.6f);
        }
        if (timeOfDay != TimeOfDay.DAY) {
            return random.m_188501_() * 0.08f - 0.04f + Math.max(0.0f, 0.008f - _wind.getStrength()) - Math.max(0.0f, _wind.getStrength() - 0.2f);
        }
        return random.m_188501_() * 0.1f - 0.05f + Math.max(0.0f, 0.008f - _wind.getStrength()) - Math.max(0.0f, _wind.getStrength() - 0.3f);
    }
}

